//--------------------------------------------------------------
// File     : main.c
// Datum    : 24.02.2018
// Version  : 1.01
// Autor    : Manfred Becker (MB)
// EMail    : -
// Web      : http://mikrocontroller.bplaced.net/
// CPU      : STM32F407 (Discovery-Board)
// IDE      : CooCox CoIDE 1.7.8
// GCC      : 4.7 2012q4
// Module   : CMSIS_BOOT, M4_CMSIS_CORE
//          : stm32_ub_i2c1.c (ab Version 1.3)
//          : stm32_ub_i2c2.c (ab Version 1.3)
//          : stm32_ub_i2c3.c (ab Version 1.3)
//          : stm32_ub_lcd_text_i2c.c (ab Version 1.0)
//          : printf.c (ab Version 07.11.2013)
// Funktion : Demo der LCD Text Anbindung ueber I2C-LoLevel-Library
// Hinweis  : Diese zwei Files muessen auf 8MHz stehen
//              "cmsis_boot/stm32f4xx.h"
//              "cmsis_boot/system_stm32f4xx.c"
//--------------------------------------------------------------

#include "main.h"
#include "stm32_ub_lcd_text_i2c.h"
#include "stdio.h" // fuer sprintf() Funktion

int main(void)
{
	LCD_TEXT_DISPLAY_t myLCD = { 
	TI2C3,	// I2C Modul (1=I2C1, 2=I2C2 oder 3=I2C3)
	0,		// I2C Adresse des LCD Displays. Falls unbekannt dann auf 0 setzen und PortScan laufen lassen.
	16,		// Anzahl Zeichen je Zeile
	2, 		// Anzahl Zeilen
	1		// LCD Hintergrundbeleuchtung (0=Aus, 1=Ein)
	};

	SystemInit(); // Quarz Einstellungen aktivieren

	// Init der I2C1-Schnittstelle
	UB_I2C_Init(&myLCD);

	// I2C Port Scan starten?
	if (myLCD.slave_adr==0x00)
	{
		uint8_t n;


		// I2C Port Scan starten von 0x01 bis 0x7F
		if ((myLCD.slave_adr = UB_LCD_TEXT_I2C_PortScan(&myLCD, 0x01, 0x7F)) != 0x00)
		{
			char txt[16];
			sprintf(txt,"I2C-Adr: 0x%02x", myLCD.slave_adr);

			// Init vom LC-Display
			UB_LCD_TEXT_I2C_Init(&myLCD);

			// Text auf Zeile-1 ausgeben
			UB_LCD_TEXT_I2C_String(&myLCD,0,0,txt);
			UB_LCD_TEXT_I2C_Delay(150);
			for (n=0; n < 11; n++)
			{
				UB_LCD_TEXT_I2C_Backlight_Toggle(&myLCD);
				UB_LCD_TEXT_I2C_Delay(50);
			}
			UB_LCD_TEXT_I2C_Backlight_On(&myLCD);
			UB_LCD_TEXT_I2C_Delay(3000);
		}
		else
		{
			//ToDo: Fehlerbehandlung
		}
	}

	// Init vom LC-Display
	UB_LCD_TEXT_I2C_Init(&myLCD);

	// Text auf Zeile-1 ausgeben
	UB_LCD_TEXT_I2C_String(&myLCD,0,0,"Hello STM32F407-");
	
	// Text auf Zeile-2 ausgeben
	UB_LCD_TEXT_I2C_String(&myLCD,0,1,"Mikrocontroller!");
	UB_LCD_TEXT_I2C_Delay(2000);

	// 4-Zeilen LCD Display?
	if (myLCD.maxy>=4)
	{
		// Clear
		UB_LCD_TEXT_I2C_Clear(&myLCD);
		UB_LCD_TEXT_I2C_SetMode(&myLCD, TLCD_TEXT_I2C_BLINK); // Display=EIN, Cursor=EIN, Blinken=EIN

		// Text auf Zeile-1 bis 4 ausgeben
		UB_LCD_TEXT_I2C_String(&myLCD,0,0,"1");
		UB_LCD_TEXT_I2C_String(&myLCD,5,1,"5");
		UB_LCD_TEXT_I2C_String(&myLCD,10,2,"10");
		UB_LCD_TEXT_I2C_String(&myLCD,15,3,"15");
		UB_LCD_TEXT_I2C_Delay(2000);

		UB_LCD_TEXT_I2C_SetMode(&myLCD, TLCD_TEXT_I2C_ON); // Display=EIN, Cursor=AUS, Blinken=Aus
	}
	

	// Clear
	UB_LCD_TEXT_I2C_Clear(&myLCD);

	// Definition eines Sonderzeichens in 8 Bytes
	uint8_t buf[8];
	buf[0]=0b01000000;
	buf[1]=0b01100000;
	buf[2]=0b01110000;
	buf[3]=0b01111000;
	buf[4]=0b01111100;
	buf[5]=0b01111110;
	buf[6]=0b01111111;
	buf[7]=0b00000000;

	UB_LCD_TEXT_I2C_WriteCG(&myLCD, 0, buf); // Speichern eines Sonderzeichens im CG-RAM vom Display

	uint8_t x,y,n;
	char* ch;

	for (y=0; y < myLCD.maxy; y++)
		for (x=0; x < myLCD.maxx; x++)
			UB_LCD_TEXT_I2C_PrintCG(&myLCD, x, y, 0); // Ausgabe des Sonderzeichens bei Pos. x,y

	UB_LCD_TEXT_I2C_Delay(2000);

	while(1)
	{
		// Testfunktion im Dauerlauf
		UB_LCD_TEXT_I2C_Clear(&myLCD);
		UB_LCD_TEXT_I2C_String(&myLCD,0,0,"LCD Txt I2C Test");
		UB_LCD_TEXT_I2C_String(&myLCD,0,1,"Please wait.....");
		UB_LCD_TEXT_I2C_Delay(2000);

		x=0; y=0;
		for (n=0; n < 256; n++)
		{
			ch=(char)n;
			UB_LCD_TEXT_I2C_String(&myLCD,x,y,&ch);
			if ((++x)>=myLCD.maxx)
			{
				x=0;
				if ((++y)>=myLCD.maxy)
				{
					y=0;
					UB_LCD_TEXT_I2C_Delay(500);
				}
			}
		}
	}
}
