//--------------------------------------------------------------
// File     : main.c
// Datum    : 15.01.2018
// Version  : 1.0
// Autor    : UB, MB
// EMail    : mc-4u(@)t-online.de
// Web      : http://mikrocontroller.bplaced.net/
// CPU      : STM32F429 (Discovery-Board)
// IDE      : CooCox CoIDE 1.7.8
// GCC      : 4.9 2015q2
// Module   : CMSIS_BOOT, M4_CMSIS_CORE
// Funktion : uBasic (Minimal-Version)
// Hinweis  : Diese zwei Files muessen auf 8MHz stehen
//              "cmsis_boot/stm32f4xx.h"
//              "cmsis_boot/system_stm32f4xx.c"
// In Configuration diese Define hinzufgen :
// "STM32F429_439xx" , "__ASSEMBLY__" , "USE_STDPERIPH_DRIVER"
// Das Beispiel Basic-Program ist in stm32_ub_ubasic.c definiert
// PRINT-Ausgabe an COM1 UART1 (TX=PA9, RX=PA10) mit 115200 Baud
//--------------------------------------------------------------

#include "main.h"
#include "stm32_ub_ubasic.h"

int main(void)
{
  ErrorStatus checkUBasic;
  char buf[RX_BUF_SIZE]; // puffer fuer Datenempfang
  UART_RXSTATUS_t checkRX;

  SystemInit(); // Quarz Einstellungen aktivieren

  // init vom uBasic
  checkUBasic=UB_UBasic_Init();
  if(checkUBasic==SUCCESS)
  {
    // Basic-Program abarbeiten
    UB_UBasic_Run();
  }

  while(1)
  {
	// check ob Daten an UART1 empfangen werden
	checkRX=UB_Uart_ReceiveString(COM1,buf);
	if(checkRX==RX_READY)
	{
		// wenn Daten empfangen wurden
		// als Echo wieder zurcksenden
		UB_Uart_SendString(COM1,buf,LFCR);
	}
  }
}
