//--------------------------------------------------------------
// File     : stm32_ub_ubasic.c
// Datum    : 24.07.2015
// Version  : 1.0
// Autor    : UB
// EMail    : mc-4u(@)t-online.de
// Web      : www.mikrocontroller-4u.de
// CPU      : STM32F4
// IDE      : CooCox CoIDE 1.7.8
// GCC      : 4.9 2015q2
// Module   : uBasic+tokenizer, Retarget_Printf
//            STM32_UB_UART
// Funktion : Basic-Interpreter (Minimal-System)
//
// Hinweis  : UART wird bei Print-Befehl benutzt
//            (kann im H-File deaktiviert werden)
//--------------------------------------------------------------


//--------------------------------------------------------------
// Includes
//--------------------------------------------------------------
#include "stm32_ub_ubasic.h"


//----------------------------------------------------------------------
void p_init_Hardware(void);
void p_clear_basic_ram(void);
void p_copy_basic_prg(void);



//----------------------------------------------------------------------
// Beispiel Basic-Program
//----------------------------------------------------------------------
static const char basic_prg[] =
"10 print \"Hello STM32F429 Discovery\"\n\
20 gosub 100\n\
30 for i = 1 to 10\n\
40 print i\n\
50 next i\n\
60 print \"end\"\n\
70 end\n\
100 print \"subroutine\"\n\
110 return\n";
static uint32_t BASIC_ROM_SIZE = sizeof(basic_prg);


//----------------------------------------------------------------------
// RAM-Array zum speichern vom Basic-Programm
//----------------------------------------------------------------------
char basic_ram[BASIC_RAM_SIZE];


//--------------------------------------------------------------
// init vom uBasic
// ret_wert :
//  -> ERROR   , wenn Fehler beim init
//  -> SUCCESS , wenn init ok
//--------------------------------------------------------------
ErrorStatus UB_UBasic_Init(void)
{
  ErrorStatus ret_wert=SUCCESS;

  // init aller Hardware Komponenten
  p_init_Hardware();

  // clear vom Basic-RAM
  p_clear_basic_ram();

  // copy vom Basic-Program
  p_copy_basic_prg();

  // init vom uBasic
  ubasic_init(basic_ram,0);

  // check ob alles ok
  if(ubasic_failed()>0) {
    // ein fehler ist aufgetreten
    ret_wert=ERROR;
  }

  return(ret_wert);
}


//--------------------------------------------------------------
// Basic-Program abarbeiten
// ret_wert :
//  -> ERROR   , wenn Fehler whrend der Abarbeitung
//  -> SUCCESS , wenn Basic-Program normal beendet wurde
//--------------------------------------------------------------
ErrorStatus UB_UBasic_Run(void)
{
  ErrorStatus ret_wert=SUCCESS;

  // loop bis Programm-Ende (oder Fehler)
  do {
    ubasic_run();
  } while(!ubasic_finished());

  // check ob alles ok
  if(ubasic_failed()>0) {
    // ein fehler ist aufgetreten
    ret_wert=ERROR;
  }

  return(ret_wert);
}


//--------------------------------------------------------------
// interne Funktion
// alle notwendigen Hardware Komponenten initialisieren
//--------------------------------------------------------------
void p_init_Hardware(void)
{
  #if USE_UART_AT_PRINT==1
    // init der UART (fr Basic-PRINT Befehl)
    UB_Uart_Init();
  #endif

  // USER : init your hardware here
}


//--------------------------------------------------------------
// interne Funktion
// loescht das Basic-RAM
//--------------------------------------------------------------
void p_clear_basic_ram(void)
{
  uint32_t n;

  for(n=0;n<BASIC_RAM_SIZE;n++) {
    basic_ram[n]=0x00;
  }
}

//--------------------------------------------------------------
// interne Funktion
// kopiert das Basic-Program vom Flash ins Basic-RAM
//--------------------------------------------------------------
void p_copy_basic_prg(void)
{
  uint32_t n;

  for(n=0;n<BASIC_ROM_SIZE;n++) {
    basic_ram[n]=basic_prg[n];
  }
}

//--------------------------------------------------------------
// USER : insert your own functions here
//--------------------------------------------------------------


