//--------------------------------------------------------------
// File     : stm32_ub_ubasic.h
//--------------------------------------------------------------

//--------------------------------------------------------------
#ifndef __STM32F4_UB_UBASIC_H
#define __STM32F4_UB_UBASIC_H


//--------------------------------------------------------------
// Includes
//--------------------------------------------------------------
#include "stm32f4xx.h"
#include "ubasic.h"



//--------------------------------------------------------------
// Speicherplatz fr Basic-Program im RAM
//--------------------------------------------------------------
#define  BASIC_RAM_SIZE  1024  // gre vom RAM in bytes


//--------------------------------------------------------------
// UART wird bei Basic-Print-Pefehl benutzt
//--------------------------------------------------------------
#define  USE_UART_AT_PRINT   1  // 0=nein, 1=ja


#if USE_UART_AT_PRINT==1
  #include "stm32_ub_uart.h"
#endif



//--------------------------------------------------------------
// Funktionen die vom uBasic aufgerufen werden
//--------------------------------------------------------------





//--------------------------------------------------------------
// Globale Funktionen
//--------------------------------------------------------------
ErrorStatus UB_UBasic_Init(void);
ErrorStatus UB_UBasic_Run(void);


//--------------------------------------------------------------
#endif // __STM32F4_UB_UBASIC_H
