/*
 * Copyright (c) 2006, Adam Dunkels
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the author nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */
#ifndef __UBASIC_H__
#define __UBASIC_H__





void ubasic_init(char *program, int mode);
void ubasic_run(void);
int ubasic_finished(void);


//------------------------------------------------------------
int ubasic_get_int_var(int varnum);
void ubasic_set_int_var(int varnum, int value);
void ubasic_set_str_var(int varnum, char *ptr); 
char *ubasic_get_str_var(int varnum);
//------------------------------------------------------------



//------------------------------------------------------------
// syntax hints
//------------------------------------------------------------
//  [numbers]
//
//  <int_var>    : 'a' to 'z'
//  <uint>       : '0' to '99999'
//  <int>        : '-99999' to '99999'
//  <hex>        : '0x0' to '0xFFFF'
//  <int_cmd>    : e.g. ABS(n)
//
//  <int_expr>   : <int_var>,<int>,<hex>,<int_cmd>
//
//------------------------------------------------------------
//  [strings]
//
//  <str_var>    : 'a$' to 'z$'
//  <str>        : e.g. "Test"
//  <str_cmd>    : e.g. MID$()
//
//  <str_expr>   : <str_var>,<str>,<str_cmd>
//
//------------------------------------------------------------
//  [other]
//
//  <cmd>        : e.g. PRINT
//  <void>       : without parameter
//  <printable>  : <int_expr>,<str_expr>
//  <tr>         : ';' or ','
//  <op>         : '+','-','*','/','%'
//  <rel>        : '=','>','<'
//
//------------------------------------------------------------







//------------------------------------------------------------
// TAB POSITIONS
//------------------------------------------------------------
#define  TAB_POS  80          // 80 Pixel per TAB



//------------------------------------------------------------
// Error-Numbers (by UB)
//------------------------------------------------------------
#define  UBASIC_PREPARSE_ERR       1
#define  UBASIC_UNEXPECTED_TOKEN   2
#define  UBASIC_INVALID_KEYWORD    3
#define  UBASIC_INVALID_DATA       4
#define  UBASIC_OVERFLOW           5
#define  UBASIC_OUT_OF_MEMORY      6





//------------------------------------------------------------
// NEW FUNCTIONS BY UB
//------------------------------------------------------------
int ubasic_failed(void);
int ubasic_linenum(void);
int ubasic_getkeyword(char token, char *ptr);

#endif /* __UBASIC_H__ */
