//--------------------------------------------------------------
// File     : main.c
// Datum    : 8.03.2018
// Version  : 1.00
// Autor    : Manfred Becker (MB)
// EMail    : -
// Web      : http://mikrocontroller.bplaced.net/
// CPU      : STM32F407 (Discovery-Board)
// IDE      : CooCox CoIDE 1.7.8
// GCC      : 4.7 2012q4
// Module   : CMSIS_BOOT, M4_CMSIS_CORE
//          : stm32_ub_led.c (ab Version 1.0)
//          : stm32_ub_button.c (ab Version 1.0)
//          : stm32_ub_i2c1.c (ab Version 1.3)
//          : stm32_ub_i2c2.c (ab Version 1.3)
//          : stm32_ub_i2c3.c (ab Version 1.3)
//          : stm32_ub_lcd_text_i2c.c (ab Version 1.0)
//          : stm32_ub_dcf77.c (ab Version 1.0)
//          : printf.c (ab Version 07.11.2013)
// Funktion : Demo der LCD Text Anbindung ueber I2C-LoLevel-Library
// Hinweis  : Diese zwei Files muessen auf 8MHz stehen
//              "cmsis_boot/stm32f4xx.h"
//              "cmsis_boot/system_stm32f4xx.c"
//--------------------------------------------------------------

#include "main.h"
#include "stm32_ub_lcd_text_i2c.h"
#include "stm32_ub_dcf77.h"
#include "stm32_ub_button.h"
#include "stm32_ub_led.h"
#include "stdio.h" // fuer sprintf() Funktion


//--------------------------------------------------------------
// Pause (ohne Timer)
// Delay :  in ms
//--------------------------------------------------------------
void Delay(uint32_t delay)
{
	uint32_t ms = delay * (SystemCoreClock / 15000U);
	while(ms--)
	{
	}
}


int main(void)
{
	LCD_TEXT_DISPLAY_t myLCD = { 
	TI2C3,	// I2C Modul (1=I2C1, 2=I2C2 oder 3=I2C3)
	0,		// I2C Adresse des LCD Displays. Falls unbekannt dann auf 0 setzen und PortScan laufen lassen.
	20,		// Anzahl Zeichen je Zeile
	4, 		// Anzahl Zeilen
	1		// LCD Hintergrundbeleuchtung (0=Aus, 1=Ein)
	};

	DCF77_Status_t status,old_status=99;
	uint8_t old_sek = 99;
	uint8_t tick = 0;
	uint8_t ss=0,mm=0,hh=0,DD=0,MM=0,JJ=0;

	char buf[20+1];
	char date[10+1];
	char time[8+1];

	SystemInit(); // Quarz Einstellungen aktivieren

	UB_Button_Init(); // Init der Buttons
	UB_Led_Init();    // Init der LEDs

	// Init der I2C1-Schnittstelle
	UB_I2C_Init(&myLCD);

	// I2C Port Scan starten?
	if (myLCD.slave_adr==0x00)
	{
		// I2C Port Scan starten von 0x01 bis 0x7F
		if ((myLCD.slave_adr = UB_LCD_TEXT_I2C_PortScan(&myLCD, 0x01, 0x7F)) != 0x00)
		{
			char txt[16];
			sprintf(txt,"I2C-Adr: 0x%02x", myLCD.slave_adr);

			// Init vom LC-Display
			UB_LCD_TEXT_I2C_Init(&myLCD);

			// Text auf Zeile-1 ausgeben
			UB_LCD_TEXT_I2C_String(&myLCD,0,0,txt);
			UB_LCD_TEXT_I2C_Delay(3000);
		}
		else
		{
			//ToDo: Fehlerbehandlung
		}
	}

	// Init vom LC-Display
	UB_LCD_TEXT_I2C_Init(&myLCD);

	// init vom DCF77-Modul
	UB_DCF77_Init();

	UB_LCD_TEXT_I2C_String(&myLCD,0,0,"DCF77");

	while(1)
	{
		// Test auf OnClick vom Button
		if(UB_Button_OnClick(BTN_USER)==true)
		{
			UB_LCD_TEXT_I2C_Backlight_Toggle(&myLCD); // LCD Hintergrundbeleuchtung toggeln
		}

		Delay(100); //UB_LCD_TEXT_I2C_Delay(100);
		UB_Led_Off(LED_RED); // rote LED ausschalten


		status=UB_DCF77_ReadTime();

		if(status!=old_status)
		{
			old_status=status;
			if(status==DCF77_NO_SIGNAL)  UB_LCD_TEXT_I2C_String(&myLCD,0,1,"No signal!");
			if(status==DCF77_READING)    UB_LCD_TEXT_I2C_String(&myLCD,0,1,"Reading...");
			if(status==DCF77_TIME_ERROR) UB_LCD_TEXT_I2C_String(&myLCD,0,1,"Error!    ");
			if(status==DCF77_TIME_OK)    UB_LCD_TEXT_I2C_String(&myLCD,0,1,"OK!       ");
		}
		if(status==DCF77_TIME_OK)
		{
			UB_Led_On(LED_GREEN); // grne LED einschalten

			if(DCF77_TIME.sek!=old_sek)
			{
				old_sek=DCF77_TIME.sek;
				hh=DCF77_TIME.std; mm=DCF77_TIME.min; ss=DCF77_TIME.sek;
				DD=DCF77_TIME.tag; MM=DCF77_TIME.monat; JJ=DCF77_TIME.jahr;

				sprintf(time,"%02d:%02d:%02d",hh,mm,ss);
				UB_LCD_TEXT_I2C_String(&myLCD,myLCD.maxx-8,0,time);

				if (myLCD.maxy>=2)
				{
					sprintf(date,"%02d.%02d.20%02d",DD,MM,JJ);
					UB_LCD_TEXT_I2C_String(&myLCD,myLCD.maxx-10,1,date);
				}

				if (myLCD.maxy>=3)
				{
					sprintf(buf,"hh=%02d, mm=%02d, ss=%02d",hh,mm,ss);
					UB_LCD_TEXT_I2C_String(&myLCD,0,2,buf);
				}
				if (myLCD.maxy>=4)
				{
					sprintf(buf,"DD=%02d, MM=%02d, JJ=%02d",DD,MM,JJ);
					UB_LCD_TEXT_I2C_String(&myLCD,0,3,buf);
				}

				tick = 0;

				UB_Led_On(LED_RED);  // rote LED einschalten
			}
		}
		else
		{
			UB_Led_Off(LED_GREEN); // grne LED ausschalten

			if ((tick++)>=10)
			{
				tick = 0;
				if ((++ss)>=60)
				{
					ss=0;
					if ((++mm)>=60)
					{
						mm=0;
						if ((++hh)>=24)
						{
							hh=0;
						}
					}
				}
				sprintf(time,"%02d:%02d:%02d",hh,mm,ss);
				UB_LCD_TEXT_I2C_String(&myLCD,myLCD.maxx-8,0,time);
				UB_Led_On(LED_RED);  // rote LED einschalten
			}
		}
	}
}
