//--------------------------------------------------------------
// File     : z80_opcode.h
//--------------------------------------------------------------

#ifndef Z80_OPCODE_TABLE_H_
#define Z80_OPCODE_TABLE_H_


#include "z80_ub.h"

//---------------------------------------------------
// zero flag table
// to avoid if statement
//---------------------------------------------------

// input = byte value
// zero flag is set, if value == 0
static const uint8_t zero_flag[256] = {
	FLAG_Z,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};


//---------------------------------------------------
// half carry flag table
// to avoid if statement
//---------------------------------------------------

// input = byte value
// half carry flag is set, if bit0..bit3 of value == Lo
// used for :
//  > increment r
//  > increment rr
static const uint8_t half_carry_flag_inc[256] = {
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_H,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
};

//---------------------------------------------------
// half carry flag table
// to avoid if statement
//---------------------------------------------------

// input = byte value
// half carry flag is set, if bit0..bit3 of value == Hi
// used for :
//  > decrement r
//  > decrement rr
static const uint8_t half_carry_flag_dec[256] = {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,FLAG_H
};





//---------------------------------------------------
// carry flag table
// to avoid if statement
//---------------------------------------------------

// input = z80.flag.register
// if carry flag is set, bit0 = Hi
// used for :
//  > add with carry
//  > subtract with carry
//  > rotate left with carry
static const uint8_t bit0_carry[256] = {
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x01
};

//---------------------------------------------------
// carry flag table
// to avoid if statement
//---------------------------------------------------

// input = z80.flag.register
// if carry flag is set, bit7 = Hi
// used for :
//  > rotate right with carry
static const uint8_t bit7_carry[256] = {
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
		0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
		0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80
};

//---------------------------------------------------
// carry flag table
// to avoid if statement
//---------------------------------------------------

// input = byte value
// carry flag is set, if value >= 0x80
// used for:
//  > rotate left with carry
static const uint8_t flag_carry_0x80[256] = {
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,
	FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,
	FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,
	FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,
	FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,
	FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,
	FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,
	FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C,FLAG_C
};

//---------------------------------------------------
// carry flag table
// to avoid if statement
//---------------------------------------------------

// input = byte value
// carry flag is set, if bit0 of value is hi
// used for:
//  > rotate right with carry
static const uint8_t flag_carry_0x01[256] = {
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,
	0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C,0,FLAG_C
};

//---------------------------------------------------
// half carry flag table
// to avoid if statement
//---------------------------------------------------

// ADD : c16bit = a8bit + b8bit
// table 0..7
// bit2 = bit3 from c16bit
// bit1 = bit3 from b8bit
// bit0 = bit3 from a8bit
static const uint8_t half_carry_flag_8bit_add[8] = {
	0,FLAG_H,FLAG_H,FLAG_H,0,0,0,FLAG_H
};

//---------------------------------------------------
// half carry flag table
// to avoid if statement
//---------------------------------------------------

// ADD : c32bit = a16bit + b16bit
// table 0..7
// bit2 = bit11 from c32bit
// bit1 = bit11 from b16bit
// bit0 = bit11 from a16bit
static const uint8_t half_carry_flag_16bit_add[8] = {
	0,FLAG_H,FLAG_H,FLAG_H,0,0,0,FLAG_H
};

//---------------------------------------------------
// half carry flag table
// to avoid if statement
//---------------------------------------------------

// SUB : c16bit = a8bit - b8bit
// table 0..7
// bit2 = bit3 from c16bit
// bit1 = bit3 from b8bit
// bit0 = bit3 from a8bit
static const uint8_t half_carry_flag_8bit_sub[8]=
{
	0, 0, FLAG_H, 0, FLAG_H, 0, FLAG_H, FLAG_H
};

//---------------------------------------------------
// half carry flag table
// to avoid if statement
//---------------------------------------------------

// SUB : c32bit = a16bit - b16bit
// table 0..7
// bit2 = bit11 from c32bit
// bit1 = bit11 from b16bit
// bit0 = bit11 from a16bit
static const uint8_t half_carry_flag_16bit_sub[8]=
{
	0, 0, FLAG_H, 0, FLAG_H, 0, FLAG_H, FLAG_H
};


//---------------------------------------------------
// DAA table
// to avoid calculation of 'carry','half carry','subtract'
//---------------------------------------------------


#define DAA_TABLE_FLAG_C	0x0100 // bit8
#define DAA_TABLE_FLAG_H	0x0200 // bit9
#define DAA_TABLE_FLAG_N	0x0400 // bit10


// table for opcode 0x27 = DAA
// table created with "daa_table_creator.exe" from UB
// input : index = bit0..7 = accu, bit8 = C, bit9 = H, bit10 = N
// output : hi_byte = accu, lo_byte = flags (Z=bit7, N=bit6, H=bit5, C=bit4)
static const uint16_t daa_flag_cnh[256*8] = {
		// flags: none [0x00]
		0x0080,0x0100,0x0200,0x0300,0x0400,0x0500,0x0600,0x0700,
		0x0800,0x0900,0x1000,0x1100,0x1200,0x1300,0x1400,0x1500,
		0x1000,0x1100,0x1200,0x1300,0x1400,0x1500,0x1600,0x1700,
		0x1800,0x1900,0x2000,0x2100,0x2200,0x2300,0x2400,0x2500,
		0x2000,0x2100,0x2200,0x2300,0x2400,0x2500,0x2600,0x2700,
		0x2800,0x2900,0x3000,0x3100,0x3200,0x3300,0x3400,0x3500,
		0x3000,0x3100,0x3200,0x3300,0x3400,0x3500,0x3600,0x3700,
		0x3800,0x3900,0x4000,0x4100,0x4200,0x4300,0x4400,0x4500,
		0x4000,0x4100,0x4200,0x4300,0x4400,0x4500,0x4600,0x4700,
		0x4800,0x4900,0x5000,0x5100,0x5200,0x5300,0x5400,0x5500,
		0x5000,0x5100,0x5200,0x5300,0x5400,0x5500,0x5600,0x5700,
		0x5800,0x5900,0x6000,0x6100,0x6200,0x6300,0x6400,0x6500,
		0x6000,0x6100,0x6200,0x6300,0x6400,0x6500,0x6600,0x6700,
		0x6800,0x6900,0x7000,0x7100,0x7200,0x7300,0x7400,0x7500,
		0x7000,0x7100,0x7200,0x7300,0x7400,0x7500,0x7600,0x7700,
		0x7800,0x7900,0x8000,0x8100,0x8200,0x8300,0x8400,0x8500,
		0x8000,0x8100,0x8200,0x8300,0x8400,0x8500,0x8600,0x8700,
		0x8800,0x8900,0x9000,0x9100,0x9200,0x9300,0x9400,0x9500,
		0x9000,0x9100,0x9200,0x9300,0x9400,0x9500,0x9600,0x9700,
		0x9800,0x9900,0x0090,0x0110,0x0210,0x0310,0x0410,0x0510,
		0x0090,0x0110,0x0210,0x0310,0x0410,0x0510,0x0610,0x0710,
		0x0810,0x0910,0x1010,0x1110,0x1210,0x1310,0x1410,0x1510,
		0x1010,0x1110,0x1210,0x1310,0x1410,0x1510,0x1610,0x1710,
		0x1810,0x1910,0x2010,0x2110,0x2210,0x2310,0x2410,0x2510,
		0x2010,0x2110,0x2210,0x2310,0x2410,0x2510,0x2610,0x2710,
		0x2810,0x2910,0x3010,0x3110,0x3210,0x3310,0x3410,0x3510,
		0x3010,0x3110,0x3210,0x3310,0x3410,0x3510,0x3610,0x3710,
		0x3810,0x3910,0x4010,0x4110,0x4210,0x4310,0x4410,0x4510,
		0x4010,0x4110,0x4210,0x4310,0x4410,0x4510,0x4610,0x4710,
		0x4810,0x4910,0x5010,0x5110,0x5210,0x5310,0x5410,0x5510,
		0x5010,0x5110,0x5210,0x5310,0x5410,0x5510,0x5610,0x5710,
		0x5810,0x5910,0x6010,0x6110,0x6210,0x6310,0x6410,0x6510,
		// flags: C [0x10]
		0x6010,0x6110,0x6210,0x6310,0x6410,0x6510,0x6610,0x6710,
		0x6810,0x6910,0x7010,0x7110,0x7210,0x7310,0x7410,0x7510,
		0x7010,0x7110,0x7210,0x7310,0x7410,0x7510,0x7610,0x7710,
		0x7810,0x7910,0x8010,0x8110,0x8210,0x8310,0x8410,0x8510,
		0x8010,0x8110,0x8210,0x8310,0x8410,0x8510,0x8610,0x8710,
		0x8810,0x8910,0x9010,0x9110,0x9210,0x9310,0x9410,0x9510,
		0x9010,0x9110,0x9210,0x9310,0x9410,0x9510,0x9610,0x9710,
		0x9810,0x9910,0xa010,0xa110,0xa210,0xa310,0xa410,0xa510,
		0xa010,0xa110,0xa210,0xa310,0xa410,0xa510,0xa610,0xa710,
		0xa810,0xa910,0xb010,0xb110,0xb210,0xb310,0xb410,0xb510,
		0xb010,0xb110,0xb210,0xb310,0xb410,0xb510,0xb610,0xb710,
		0xb810,0xb910,0xc010,0xc110,0xc210,0xc310,0xc410,0xc510,
		0xc010,0xc110,0xc210,0xc310,0xc410,0xc510,0xc610,0xc710,
		0xc810,0xc910,0xd010,0xd110,0xd210,0xd310,0xd410,0xd510,
		0xd010,0xd110,0xd210,0xd310,0xd410,0xd510,0xd610,0xd710,
		0xd810,0xd910,0xe010,0xe110,0xe210,0xe310,0xe410,0xe510,
		0xe010,0xe110,0xe210,0xe310,0xe410,0xe510,0xe610,0xe710,
		0xe810,0xe910,0xf010,0xf110,0xf210,0xf310,0xf410,0xf510,
		0xf010,0xf110,0xf210,0xf310,0xf410,0xf510,0xf610,0xf710,
		0xf810,0xf910,0x0090,0x0110,0x0210,0x0310,0x0410,0x0510,
		0x0090,0x0110,0x0210,0x0310,0x0410,0x0510,0x0610,0x0710,
		0x0810,0x0910,0x1010,0x1110,0x1210,0x1310,0x1410,0x1510,
		0x1010,0x1110,0x1210,0x1310,0x1410,0x1510,0x1610,0x1710,
		0x1810,0x1910,0x2010,0x2110,0x2210,0x2310,0x2410,0x2510,
		0x2010,0x2110,0x2210,0x2310,0x2410,0x2510,0x2610,0x2710,
		0x2810,0x2910,0x3010,0x3110,0x3210,0x3310,0x3410,0x3510,
		0x3010,0x3110,0x3210,0x3310,0x3410,0x3510,0x3610,0x3710,
		0x3810,0x3910,0x4010,0x4110,0x4210,0x4310,0x4410,0x4510,
		0x4010,0x4110,0x4210,0x4310,0x4410,0x4510,0x4610,0x4710,
		0x4810,0x4910,0x5010,0x5110,0x5210,0x5310,0x5410,0x5510,
		0x5010,0x5110,0x5210,0x5310,0x5410,0x5510,0x5610,0x5710,
		0x5810,0x5910,0x6010,0x6110,0x6210,0x6310,0x6410,0x6510,
		// flags: H [0x20]
		0x0600,0x0700,0x0800,0x0900,0x0a00,0x0b00,0x0c00,0x0d00,
		0x0e00,0x0f00,0x1000,0x1100,0x1200,0x1300,0x1400,0x1500,
		0x1600,0x1700,0x1800,0x1900,0x1a00,0x1b00,0x1c00,0x1d00,
		0x1e00,0x1f00,0x2000,0x2100,0x2200,0x2300,0x2400,0x2500,
		0x2600,0x2700,0x2800,0x2900,0x2a00,0x2b00,0x2c00,0x2d00,
		0x2e00,0x2f00,0x3000,0x3100,0x3200,0x3300,0x3400,0x3500,
		0x3600,0x3700,0x3800,0x3900,0x3a00,0x3b00,0x3c00,0x3d00,
		0x3e00,0x3f00,0x4000,0x4100,0x4200,0x4300,0x4400,0x4500,
		0x4600,0x4700,0x4800,0x4900,0x4a00,0x4b00,0x4c00,0x4d00,
		0x4e00,0x4f00,0x5000,0x5100,0x5200,0x5300,0x5400,0x5500,
		0x5600,0x5700,0x5800,0x5900,0x5a00,0x5b00,0x5c00,0x5d00,
		0x5e00,0x5f00,0x6000,0x6100,0x6200,0x6300,0x6400,0x6500,
		0x6600,0x6700,0x6800,0x6900,0x6a00,0x6b00,0x6c00,0x6d00,
		0x6e00,0x6f00,0x7000,0x7100,0x7200,0x7300,0x7400,0x7500,
		0x7600,0x7700,0x7800,0x7900,0x7a00,0x7b00,0x7c00,0x7d00,
		0x7e00,0x7f00,0x8000,0x8100,0x8200,0x8300,0x8400,0x8500,
		0x8600,0x8700,0x8800,0x8900,0x8a00,0x8b00,0x8c00,0x8d00,
		0x8e00,0x8f00,0x9000,0x9100,0x9200,0x9300,0x9400,0x9500,
		0x9600,0x9700,0x9800,0x9900,0x9a00,0x9b00,0x9c00,0x9d00,
		0x9e00,0x9f00,0x0090,0x0110,0x0210,0x0310,0x0410,0x0510,
		0x0610,0x0710,0x0810,0x0910,0x0a10,0x0b10,0x0c10,0x0d10,
		0x0e10,0x0f10,0x1010,0x1110,0x1210,0x1310,0x1410,0x1510,
		0x1610,0x1710,0x1810,0x1910,0x1a10,0x1b10,0x1c10,0x1d10,
		0x1e10,0x1f10,0x2010,0x2110,0x2210,0x2310,0x2410,0x2510,
		0x2610,0x2710,0x2810,0x2910,0x2a10,0x2b10,0x2c10,0x2d10,
		0x2e10,0x2f10,0x3010,0x3110,0x3210,0x3310,0x3410,0x3510,
		0x3610,0x3710,0x3810,0x3910,0x3a10,0x3b10,0x3c10,0x3d10,
		0x3e10,0x3f10,0x4010,0x4110,0x4210,0x4310,0x4410,0x4510,
		0x4610,0x4710,0x4810,0x4910,0x4a10,0x4b10,0x4c10,0x4d10,
		0x4e10,0x4f10,0x5010,0x5110,0x5210,0x5310,0x5410,0x5510,
		0x5610,0x5710,0x5810,0x5910,0x5a10,0x5b10,0x5c10,0x5d10,
		0x5e10,0x5f10,0x6010,0x6110,0x6210,0x6310,0x6410,0x6510,
		// flags: C,H [0x30]
		0x6610,0x6710,0x6810,0x6910,0x6a10,0x6b10,0x6c10,0x6d10,
		0x6e10,0x6f10,0x7010,0x7110,0x7210,0x7310,0x7410,0x7510,
		0x7610,0x7710,0x7810,0x7910,0x7a10,0x7b10,0x7c10,0x7d10,
		0x7e10,0x7f10,0x8010,0x8110,0x8210,0x8310,0x8410,0x8510,
		0x8610,0x8710,0x8810,0x8910,0x8a10,0x8b10,0x8c10,0x8d10,
		0x8e10,0x8f10,0x9010,0x9110,0x9210,0x9310,0x9410,0x9510,
		0x9610,0x9710,0x9810,0x9910,0x9a10,0x9b10,0x9c10,0x9d10,
		0x9e10,0x9f10,0xa010,0xa110,0xa210,0xa310,0xa410,0xa510,
		0xa610,0xa710,0xa810,0xa910,0xaa10,0xab10,0xac10,0xad10,
		0xae10,0xaf10,0xb010,0xb110,0xb210,0xb310,0xb410,0xb510,
		0xb610,0xb710,0xb810,0xb910,0xba10,0xbb10,0xbc10,0xbd10,
		0xbe10,0xbf10,0xc010,0xc110,0xc210,0xc310,0xc410,0xc510,
		0xc610,0xc710,0xc810,0xc910,0xca10,0xcb10,0xcc10,0xcd10,
		0xce10,0xcf10,0xd010,0xd110,0xd210,0xd310,0xd410,0xd510,
		0xd610,0xd710,0xd810,0xd910,0xda10,0xdb10,0xdc10,0xdd10,
		0xde10,0xdf10,0xe010,0xe110,0xe210,0xe310,0xe410,0xe510,
		0xe610,0xe710,0xe810,0xe910,0xea10,0xeb10,0xec10,0xed10,
		0xee10,0xef10,0xf010,0xf110,0xf210,0xf310,0xf410,0xf510,
		0xf610,0xf710,0xf810,0xf910,0xfa10,0xfb10,0xfc10,0xfd10,
		0xfe10,0xff10,0x0090,0x0110,0x0210,0x0310,0x0410,0x0510,
		0x0610,0x0710,0x0810,0x0910,0x0a10,0x0b10,0x0c10,0x0d10,
		0x0e10,0x0f10,0x1010,0x1110,0x1210,0x1310,0x1410,0x1510,
		0x1610,0x1710,0x1810,0x1910,0x1a10,0x1b10,0x1c10,0x1d10,
		0x1e10,0x1f10,0x2010,0x2110,0x2210,0x2310,0x2410,0x2510,
		0x2610,0x2710,0x2810,0x2910,0x2a10,0x2b10,0x2c10,0x2d10,
		0x2e10,0x2f10,0x3010,0x3110,0x3210,0x3310,0x3410,0x3510,
		0x3610,0x3710,0x3810,0x3910,0x3a10,0x3b10,0x3c10,0x3d10,
		0x3e10,0x3f10,0x4010,0x4110,0x4210,0x4310,0x4410,0x4510,
		0x4610,0x4710,0x4810,0x4910,0x4a10,0x4b10,0x4c10,0x4d10,
		0x4e10,0x4f10,0x5010,0x5110,0x5210,0x5310,0x5410,0x5510,
		0x5610,0x5710,0x5810,0x5910,0x5a10,0x5b10,0x5c10,0x5d10,
		0x5e10,0x5f10,0x6010,0x6110,0x6210,0x6310,0x6410,0x6510,
		// flags: N [0x40]
		0x00c0,0x0140,0x0240,0x0340,0x0440,0x0540,0x0640,0x0740,
		0x0840,0x0940,0x0a40,0x0b40,0x0c40,0x0d40,0x0e40,0x0f40,
		0x1040,0x1140,0x1240,0x1340,0x1440,0x1540,0x1640,0x1740,
		0x1840,0x1940,0x1a40,0x1b40,0x1c40,0x1d40,0x1e40,0x1f40,
		0x2040,0x2140,0x2240,0x2340,0x2440,0x2540,0x2640,0x2740,
		0x2840,0x2940,0x2a40,0x2b40,0x2c40,0x2d40,0x2e40,0x2f40,
		0x3040,0x3140,0x3240,0x3340,0x3440,0x3540,0x3640,0x3740,
		0x3840,0x3940,0x3a40,0x3b40,0x3c40,0x3d40,0x3e40,0x3f40,
		0x4040,0x4140,0x4240,0x4340,0x4440,0x4540,0x4640,0x4740,
		0x4840,0x4940,0x4a40,0x4b40,0x4c40,0x4d40,0x4e40,0x4f40,
		0x5040,0x5140,0x5240,0x5340,0x5440,0x5540,0x5640,0x5740,
		0x5840,0x5940,0x5a40,0x5b40,0x5c40,0x5d40,0x5e40,0x5f40,
		0x6040,0x6140,0x6240,0x6340,0x6440,0x6540,0x6640,0x6740,
		0x6840,0x6940,0x6a40,0x6b40,0x6c40,0x6d40,0x6e40,0x6f40,
		0x7040,0x7140,0x7240,0x7340,0x7440,0x7540,0x7640,0x7740,
		0x7840,0x7940,0x7a40,0x7b40,0x7c40,0x7d40,0x7e40,0x7f40,
		0x8040,0x8140,0x8240,0x8340,0x8440,0x8540,0x8640,0x8740,
		0x8840,0x8940,0x8a40,0x8b40,0x8c40,0x8d40,0x8e40,0x8f40,
		0x9040,0x9140,0x9240,0x9340,0x9440,0x9540,0x9640,0x9740,
		0x9840,0x9940,0x9a40,0x9b40,0x9c40,0x9d40,0x9e40,0x9f40,
		0xa040,0xa140,0xa240,0xa340,0xa440,0xa540,0xa640,0xa740,
		0xa840,0xa940,0xaa40,0xab40,0xac40,0xad40,0xae40,0xaf40,
		0xb040,0xb140,0xb240,0xb340,0xb440,0xb540,0xb640,0xb740,
		0xb840,0xb940,0xba40,0xbb40,0xbc40,0xbd40,0xbe40,0xbf40,
		0xc040,0xc140,0xc240,0xc340,0xc440,0xc540,0xc640,0xc740,
		0xc840,0xc940,0xca40,0xcb40,0xcc40,0xcd40,0xce40,0xcf40,
		0xd040,0xd140,0xd240,0xd340,0xd440,0xd540,0xd640,0xd740,
		0xd840,0xd940,0xda40,0xdb40,0xdc40,0xdd40,0xde40,0xdf40,
		0xe040,0xe140,0xe240,0xe340,0xe440,0xe540,0xe640,0xe740,
		0xe840,0xe940,0xea40,0xeb40,0xec40,0xed40,0xee40,0xef40,
		0xf040,0xf140,0xf240,0xf340,0xf440,0xf540,0xf640,0xf740,
		0xf840,0xf940,0xfa40,0xfb40,0xfc40,0xfd40,0xfe40,0xff40,
		// flags: C,N [0x50]
		0xa050,0xa150,0xa250,0xa350,0xa450,0xa550,0xa650,0xa750,
		0xa850,0xa950,0xaa50,0xab50,0xac50,0xad50,0xae50,0xaf50,
		0xb050,0xb150,0xb250,0xb350,0xb450,0xb550,0xb650,0xb750,
		0xb850,0xb950,0xba50,0xbb50,0xbc50,0xbd50,0xbe50,0xbf50,
		0xc050,0xc150,0xc250,0xc350,0xc450,0xc550,0xc650,0xc750,
		0xc850,0xc950,0xca50,0xcb50,0xcc50,0xcd50,0xce50,0xcf50,
		0xd050,0xd150,0xd250,0xd350,0xd450,0xd550,0xd650,0xd750,
		0xd850,0xd950,0xda50,0xdb50,0xdc50,0xdd50,0xde50,0xdf50,
		0xe050,0xe150,0xe250,0xe350,0xe450,0xe550,0xe650,0xe750,
		0xe850,0xe950,0xea50,0xeb50,0xec50,0xed50,0xee50,0xef50,
		0xf050,0xf150,0xf250,0xf350,0xf450,0xf550,0xf650,0xf750,
		0xf850,0xf950,0xfa50,0xfb50,0xfc50,0xfd50,0xfe50,0xff50,
		0x00d0,0x0150,0x0250,0x0350,0x0450,0x0550,0x0650,0x0750,
		0x0850,0x0950,0x0a50,0x0b50,0x0c50,0x0d50,0x0e50,0x0f50,
		0x1050,0x1150,0x1250,0x1350,0x1450,0x1550,0x1650,0x1750,
		0x1850,0x1950,0x1a50,0x1b50,0x1c50,0x1d50,0x1e50,0x1f50,
		0x2050,0x2150,0x2250,0x2350,0x2450,0x2550,0x2650,0x2750,
		0x2850,0x2950,0x2a50,0x2b50,0x2c50,0x2d50,0x2e50,0x2f50,
		0x3050,0x3150,0x3250,0x3350,0x3450,0x3550,0x3650,0x3750,
		0x3850,0x3950,0x3a50,0x3b50,0x3c50,0x3d50,0x3e50,0x3f50,
		0x4050,0x4150,0x4250,0x4350,0x4450,0x4550,0x4650,0x4750,
		0x4850,0x4950,0x4a50,0x4b50,0x4c50,0x4d50,0x4e50,0x4f50,
		0x5050,0x5150,0x5250,0x5350,0x5450,0x5550,0x5650,0x5750,
		0x5850,0x5950,0x5a50,0x5b50,0x5c50,0x5d50,0x5e50,0x5f50,
		0x6050,0x6150,0x6250,0x6350,0x6450,0x6550,0x6650,0x6750,
		0x6850,0x6950,0x6a50,0x6b50,0x6c50,0x6d50,0x6e50,0x6f50,
		0x7050,0x7150,0x7250,0x7350,0x7450,0x7550,0x7650,0x7750,
		0x7850,0x7950,0x7a50,0x7b50,0x7c50,0x7d50,0x7e50,0x7f50,
		0x8050,0x8150,0x8250,0x8350,0x8450,0x8550,0x8650,0x8750,
		0x8850,0x8950,0x8a50,0x8b50,0x8c50,0x8d50,0x8e50,0x8f50,
		0x9050,0x9150,0x9250,0x9350,0x9450,0x9550,0x9650,0x9750,
		0x9850,0x9950,0x9a50,0x9b50,0x9c50,0x9d50,0x9e50,0x9f50,
		// flags: H,N [0x60]
		0xfa40,0xfb40,0xfc40,0xfd40,0xfe40,0xff40,0x00c0,0x0140,
		0x0240,0x0340,0x0440,0x0540,0x0640,0x0740,0x0840,0x0940,
		0x0a40,0x0b40,0x0c40,0x0d40,0x0e40,0x0f40,0x1040,0x1140,
		0x1240,0x1340,0x1440,0x1540,0x1640,0x1740,0x1840,0x1940,
		0x1a40,0x1b40,0x1c40,0x1d40,0x1e40,0x1f40,0x2040,0x2140,
		0x2240,0x2340,0x2440,0x2540,0x2640,0x2740,0x2840,0x2940,
		0x2a40,0x2b40,0x2c40,0x2d40,0x2e40,0x2f40,0x3040,0x3140,
		0x3240,0x3340,0x3440,0x3540,0x3640,0x3740,0x3840,0x3940,
		0x3a40,0x3b40,0x3c40,0x3d40,0x3e40,0x3f40,0x4040,0x4140,
		0x4240,0x4340,0x4440,0x4540,0x4640,0x4740,0x4840,0x4940,
		0x4a40,0x4b40,0x4c40,0x4d40,0x4e40,0x4f40,0x5040,0x5140,
		0x5240,0x5340,0x5440,0x5540,0x5640,0x5740,0x5840,0x5940,
		0x5a40,0x5b40,0x5c40,0x5d40,0x5e40,0x5f40,0x6040,0x6140,
		0x6240,0x6340,0x6440,0x6540,0x6640,0x6740,0x6840,0x6940,
		0x6a40,0x6b40,0x6c40,0x6d40,0x6e40,0x6f40,0x7040,0x7140,
		0x7240,0x7340,0x7440,0x7540,0x7640,0x7740,0x7840,0x7940,
		0x7a40,0x7b40,0x7c40,0x7d40,0x7e40,0x7f40,0x8040,0x8140,
		0x8240,0x8340,0x8440,0x8540,0x8640,0x8740,0x8840,0x8940,
		0x8a40,0x8b40,0x8c40,0x8d40,0x8e40,0x8f40,0x9040,0x9140,
		0x9240,0x9340,0x9440,0x9540,0x9640,0x9740,0x9840,0x9940,
		0x9a40,0x9b40,0x9c40,0x9d40,0x9e40,0x9f40,0xa040,0xa140,
		0xa240,0xa340,0xa440,0xa540,0xa640,0xa740,0xa840,0xa940,
		0xaa40,0xab40,0xac40,0xad40,0xae40,0xaf40,0xb040,0xb140,
		0xb240,0xb340,0xb440,0xb540,0xb640,0xb740,0xb840,0xb940,
		0xba40,0xbb40,0xbc40,0xbd40,0xbe40,0xbf40,0xc040,0xc140,
		0xc240,0xc340,0xc440,0xc540,0xc640,0xc740,0xc840,0xc940,
		0xca40,0xcb40,0xcc40,0xcd40,0xce40,0xcf40,0xd040,0xd140,
		0xd240,0xd340,0xd440,0xd540,0xd640,0xd740,0xd840,0xd940,
		0xda40,0xdb40,0xdc40,0xdd40,0xde40,0xdf40,0xe040,0xe140,
		0xe240,0xe340,0xe440,0xe540,0xe640,0xe740,0xe840,0xe940,
		0xea40,0xeb40,0xec40,0xed40,0xee40,0xef40,0xf040,0xf140,
		0xf240,0xf340,0xf440,0xf540,0xf640,0xf740,0xf840,0xf940,
		// flags: C,H,N [0x70]
		0x9a50,0x9b50,0x9c50,0x9d50,0x9e50,0x9f50,0xa050,0xa150,
		0xa250,0xa350,0xa450,0xa550,0xa650,0xa750,0xa850,0xa950,
		0xaa50,0xab50,0xac50,0xad50,0xae50,0xaf50,0xb050,0xb150,
		0xb250,0xb350,0xb450,0xb550,0xb650,0xb750,0xb850,0xb950,
		0xba50,0xbb50,0xbc50,0xbd50,0xbe50,0xbf50,0xc050,0xc150,
		0xc250,0xc350,0xc450,0xc550,0xc650,0xc750,0xc850,0xc950,
		0xca50,0xcb50,0xcc50,0xcd50,0xce50,0xcf50,0xd050,0xd150,
		0xd250,0xd350,0xd450,0xd550,0xd650,0xd750,0xd850,0xd950,
		0xda50,0xdb50,0xdc50,0xdd50,0xde50,0xdf50,0xe050,0xe150,
		0xe250,0xe350,0xe450,0xe550,0xe650,0xe750,0xe850,0xe950,
		0xea50,0xeb50,0xec50,0xed50,0xee50,0xef50,0xf050,0xf150,
		0xf250,0xf350,0xf450,0xf550,0xf650,0xf750,0xf850,0xf950,
		0xfa50,0xfb50,0xfc50,0xfd50,0xfe50,0xff50,0x00d0,0x0150,
		0x0250,0x0350,0x0450,0x0550,0x0650,0x0750,0x0850,0x0950,
		0x0a50,0x0b50,0x0c50,0x0d50,0x0e50,0x0f50,0x1050,0x1150,
		0x1250,0x1350,0x1450,0x1550,0x1650,0x1750,0x1850,0x1950,
		0x1a50,0x1b50,0x1c50,0x1d50,0x1e50,0x1f50,0x2050,0x2150,
		0x2250,0x2350,0x2450,0x2550,0x2650,0x2750,0x2850,0x2950,
		0x2a50,0x2b50,0x2c50,0x2d50,0x2e50,0x2f50,0x3050,0x3150,
		0x3250,0x3350,0x3450,0x3550,0x3650,0x3750,0x3850,0x3950,
		0x3a50,0x3b50,0x3c50,0x3d50,0x3e50,0x3f50,0x4050,0x4150,
		0x4250,0x4350,0x4450,0x4550,0x4650,0x4750,0x4850,0x4950,
		0x4a50,0x4b50,0x4c50,0x4d50,0x4e50,0x4f50,0x5050,0x5150,
		0x5250,0x5350,0x5450,0x5550,0x5650,0x5750,0x5850,0x5950,
		0x5a50,0x5b50,0x5c50,0x5d50,0x5e50,0x5f50,0x6050,0x6150,
		0x6250,0x6350,0x6450,0x6550,0x6650,0x6750,0x6850,0x6950,
		0x6a50,0x6b50,0x6c50,0x6d50,0x6e50,0x6f50,0x7050,0x7150,
		0x7250,0x7350,0x7450,0x7550,0x7650,0x7750,0x7850,0x7950,
		0x7a50,0x7b50,0x7c50,0x7d50,0x7e50,0x7f50,0x8050,0x8150,
		0x8250,0x8350,0x8450,0x8550,0x8650,0x8750,0x8850,0x8950,
		0x8a50,0x8b50,0x8c50,0x8d50,0x8e50,0x8f50,0x9050,0x9150,
		0x9250,0x9350,0x9450,0x9550,0x9650,0x9750,0x9850,0x9950
};


#endif /* Z80_OPCODE_TABLE_H_ */
