//--------------------------------------------------------------
// File     : z80_opcode.h
//--------------------------------------------------------------

#ifndef Z80_OPCODE_CB_H_
#define Z80_OPCODE_CB_H_

#include "stm32f7xx.h"
#include "z80_ub.h"




//------------------------------------------------
// ROTATE
//------------------------------------------------

#define RL_R(value) { \
z80_byte = (value << 1) | bit0_carry[z80.reg.f]; \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x80[value]; \
value = z80_byte; \
z80.reg.pc+=2; \
}

#define RLC_R(value) { \
z80.reg.f = flag_carry_0x80[value]; \
z80_byte = (value << 1) | (value>>7); \
value = z80_byte; \
z80.reg.f |= zero_flag[z80_byte]; \
z80.reg.pc+=2; \
}

#define RLC_M(adr) { \
u8_temp=RD_BYTE_MEM(adr); \
z80.reg.f = flag_carry_0x80[u8_temp]; \
z80_byte = (u8_temp << 1) | (u8_temp>>7); \
WR_BYTE_MEM(adr, z80_byte); \
z80.reg.f |= zero_flag[z80_byte]; \
z80.reg.pc+=2; \
}

#define RL_M(adr) { \
u8_temp = RD_BYTE_MEM(adr); \
z80_byte = (u8_temp << 1) | bit0_carry[z80.reg.f]; \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x80[u8_temp]; \
WR_BYTE_MEM(adr, z80_byte); \
z80.reg.pc+=2; \
}

#define RR_R(value) { \
z80_byte = (value >> 1) | bit7_carry[z80.reg.f]; \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x01[value]; \
value = z80_byte; \
z80.reg.pc+=2; \
}

#define RRC_R(value) { \
z80.reg.f = flag_carry_0x01[value]; \
z80_byte = (value >> 1) | (value<<7); \
value = z80_byte; \
z80.reg.f |= zero_flag[z80_byte]; \
z80.reg.pc+=2; \
}

#define RRC_M(adr) { \
u8_temp = RD_BYTE_MEM(adr); \
z80.reg.f = flag_carry_0x01[u8_temp]; \
z80_byte = (u8_temp >> 1) | (u8_temp<<7); \
WR_BYTE_MEM(adr, z80_byte); \
z80.reg.f |= zero_flag[z80_byte]; \
z80.reg.pc+=2; \
}

#define RR_M(adr) { \
u8_temp = RD_BYTE_MEM(adr); \
z80_byte = (u8_temp >> 1) | bit7_carry[z80.reg.f]; \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x01[u8_temp]; \
WR_BYTE_MEM(adr, z80_byte); \
z80.reg.pc+=2; \
}

//------------------------------------------------
// SHIFT
//------------------------------------------------

#define SLA_R(value) { \
z80_byte = (value << 1); \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x80[value]; \
value = z80_byte; \
z80.reg.pc+=2; \
}

#define SLA_M(adr) { \
u8_temp = RD_BYTE_MEM(adr); \
z80_byte = (u8_temp << 1); \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x80[u8_temp]; \
WR_BYTE_MEM(adr, z80_byte); \
z80.reg.pc+=2; \
}

#define SRA_R(value) { \
z80_byte = (value >> 1) | (value & 0x80); \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x01[value]; \
value = z80_byte; \
z80.reg.pc+=2; \
}

#define SRA_M(adr) { \
u8_temp = RD_BYTE_MEM(adr); \
z80_byte = (u8_temp >> 1) | (u8_temp & 0x80); \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x01[u8_temp]; \
WR_BYTE_MEM(adr, z80_byte); \
z80.reg.pc+=2; \
}

#define SRL_R(value) { \
z80_byte = (value >> 1); \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x01[value]; \
value = z80_byte; \
z80.reg.pc+=2; \
}

#define SRL_M(adr) { \
u8_temp = RD_BYTE_MEM(adr); \
z80_byte = (u8_temp >> 1); \
z80.reg.f = zero_flag[z80_byte] | flag_carry_0x01[u8_temp]; \
WR_BYTE_MEM(adr, z80_byte); \
z80.reg.pc+=2; \
}

//------------------------------------------------
// SWAP
//------------------------------------------------

#define SWAP_R(value) { \
z80_byte = (value << 4) | (value >> 4); \
value = z80_byte; \
z80.reg.f = zero_flag[value]; \
z80.reg.pc+=2; \
}

#define SWAP_M(adr) { \
u8_temp = RD_BYTE_MEM(adr); \
z80_byte = (u8_temp << 4) | (u8_temp >> 4); \
WR_BYTE_MEM(adr, z80_byte); \
z80.reg.f = zero_flag[z80_byte]; \
z80.reg.pc+=2; \
}

//------------------------------------------------
// BIT
//------------------------------------------------

#define BIT_R(source,value) {z80.reg.f = zero_flag[(source & value)] | FLAG_H | (z80.reg.f & FLAG_C); z80.reg.pc+=2;}

#define BIT_M(value) { \
z80_byte = RD_BYTE_MEM(z80.reg.hl); \
z80.reg.f = zero_flag[(z80_byte & value)] | FLAG_H | (z80.reg.f & FLAG_C); \
z80.reg.pc+=2; \
}

//------------------------------------------------
// SET
//------------------------------------------------

#define SET_R(source,value) {source |= value; z80.reg.pc+=2;}

#define SET_M(value) {z80_byte = RD_BYTE_MEM(z80.reg.hl); z80_byte |= value; WR_BYTE_MEM(z80.reg.hl, z80_byte); z80.reg.pc+=2;}

//------------------------------------------------
// RESET
//------------------------------------------------

#define RES_R(source,value) {source &= value; z80.reg.pc+=2;}

#define RES_M(value) { \
z80_byte = RD_BYTE_MEM(z80.reg.hl); \
z80_byte &= value; \
WR_BYTE_MEM(z80.reg.hl, z80_byte); \
z80.reg.pc+=2; \
}


//------------------------------------------------
// mcu cycles for each CB opcode
//------------------------------------------------
static const uint8_t cycles_cb[256] = {
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8,
	8,8,8,8,8,8,16,8,8,8,8,8,8,8,16,8
};



#endif /* Z80_OPCODE_TABLE_CB_H_ */
