/**
  ******************************************************************************
  * @file    stm32f7xx_it.c
  * @author  Ac6
  * @version V1.0
  * @date    02-Feb-2015
  * @brief   Default Interrupt Service Routines.
  ******************************************************************************
*/

/* Includes ------------------------------------------------------------------*/
#include "stm32f7xx_hal.h"
#include "stm32f7xx.h"
#ifdef USE_RTOS_SYSTICK
#include <cmsis_os.h>
#endif
#include "stm32f7xx_it.h"
#include "gameboy_ub.h"
#include "stm32_ub_led.h"

/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
/* Private functions ---------------------------------------------------------*/

/******************************************************************************/
/*            	  	    Processor Exceptions Handlers                         */
/******************************************************************************/

/**
  * @brief  This function handles SysTick Handler, but only if no RTOS defines it.
  * @param  None
  * @retval None
  */
void SysTick_Handler(void)
{
	static uint32_t cnt1 = 0;

	HAL_IncTick();
	HAL_SYSTICK_IRQHandler();

	GB.key.delay_cnt++;

	// fps measurement (every 500ms)
	cnt1++;
	if(cnt1 >= 500) {
		cnt1 = 0;

		UB_Led_Toggle(LED_GREEN1);
		GB.frame.fps = (GB.frame.cnt<<1);
		GB.frame.cnt = 0;
		GB.frame.flag = 1;
	}

	// timing measurement
#ifndef DEBUG
	if(cnt1 == 0) {
		GB.timing.current_fps = GB.frame.fps;
		GB.timing.flag = 1;
	}
#endif
}
