//--------------------------------------------------------------
// File     : stm32_ub_usb_hid_host.h
//--------------------------------------------------------------

//--------------------------------------------------------------
#ifndef __STM32F7_UB_USB_HID_HOST_H
#define __STM32F7_UB_USB_HID_HOST_H

#ifndef USE_USB_FS
  #ifndef USE_USB_HS
    #error "Please define USE_USB_FS or USE_USB_HS"
  #endif
#endif


//--------------------------------------------------------------
// Includes
//--------------------------------------------------------------
#include "stm32_ub_system.h"
#include "usbh_core.h"
#include "usbh_hid.h"
#include "usbh_hid_parser.h"


//--------------------------------------------------------------
typedef enum {
  APPLICATION_IDLE = 0,
  APPLICATION_DISCONNECT,
  APPLICATION_START,
  APPLICATION_READY,
  APPLICATION_RUNNING,
}HID_ApplicationTypeDef;


//--------------------------------------------------------------
// Status der USB-Verbindung
//--------------------------------------------------------------
typedef enum {
  USB_HID_HOST_NO_INIT =0,   // USB-Schnittstelle noch nicht initialisiert
  USB_HID_DEV_DETACHED,      // kein Device angeschlossen
  USB_HID_SPEED_OK,          // USB-Speed wird untersttzt
  USB_HID_SPEED_ERROR,       // USB-Speed wird nicht untersttzt
  USB_HID_DEV_NOT_SUPPORTED, // Device wird nicht unterstzt
  USB_HID_OVER_CURRENT,      // berstrom erkannt
  USB_HID_DEV_CONNECTED,     // Device verbunden noch nicht bereit
  USB_HID_MOUSE_CONNECTED,   // Mouse verbunden und bereit
  USB_HID_KEYBOARD_CONNECTED // Tastatur verbunden und bereit
}USB_HID_HOST_STATUS_t;
USB_HID_HOST_STATUS_t USB_HID_HOST_STATUS;


//--------------------------------------------------------------
#define   USB_MOUSE_XPOS_MAX  480-1
#define   USB_MOUSE_YPOS_MAX  272-1

//--------------------------------------------------------------
typedef enum {
  MOUSE_BTN_RELEASED =0,      // Maus Taste losgelassen
  MOUSE_BTN_PRESSED           // Maus Taste bettigt
}USB_HID_BTN;


//--------------------------------------------------------------
// Globale Struktur der Mouse-Daten
//--------------------------------------------------------------
typedef struct {
  USB_HID_BTN btn_left;     // Status der linken Maustaste
  USB_HID_BTN btn_right;    // Status der rechten Maustaste
  USB_HID_BTN btn_center;   // Status der mittleren Maustaste
  uint16_t xpos;            // aktuelle X-Pos
  uint16_t ypos;            // aktuelle Y-Pos
}USB_MOUSE_DATA_t;
USB_MOUSE_DATA_t USB_MOUSE_DATA;



//--------------------------------------------------------------
// Globale Struktur der Keyboard-Daten
//--------------------------------------------------------------
typedef struct {
  uint8_t akt_key1;         // Tastencode der Taste 1
  uint8_t akt_key2;         // Tastencode der Taste 2
  uint8_t ascii_key1;       // Asciicode der Taste 1
  uint8_t ascii_key2;       // Asciicode der Taste 2
  uint8_t akt_shift;        // Shift-Status
}USB_KEY_DATA_t;
USB_KEY_DATA_t USB_KEY_DATA;



//--------------------------------------------------------------
// Globale Funktionen
//--------------------------------------------------------------
void UB_USB_HID_HOST_Init(void);
USB_HID_HOST_STATUS_t UB_USB_HID_HOST_Do(void);
uint8_t UB_USB_HID_HOST_GetKey(void);
uint8_t UB_USB_HID_HOST_GetKeyAnz(void);
uint8_t UB_USB_HID_HOST_GetShift(void);
uint8_t UB_USB_HID_HOST_GetMouse(void);





//--------------------------------------------------------------
#endif // __STM32F7_UB_USB_HID_HOST_H
