unit PolyEdit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Btn_Load: TButton;
    Btn_Back: TButton;
    Btn_Save: TButton;
    Btn_Reset: TButton;
    Img: TImage;
    lbl_001: TLabel;
    lbl_1: TLabel;
    lbl_ShowGrid: TLabel;
    lbl_fillpoly: TLabel;
    lbl_set_center: TLabel;
    lbl_X: TLabel;
    lbl_add: TLabel;
    lbl_000: TLabel;
    lbl_snap: TLabel;
    lbl_move: TLabel;
    lbl_addbetween: TLabel;
    lbl_delete: TLabel;
    lbl_Y: TLabel;
    lbl_NbPoint: TLabel;
    F_Open: TOpenDialog;
    Panel1: TPanel;
    Panel2: TPanel;
    F_Save: TSaveDialog;
    procedure Btn_BackClick(Sender: TObject);
    procedure Btn_LoadClick(Sender: TObject);
    procedure Btn_ResetClick(Sender: TObject);
    procedure Btn_SaveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ImgClick(Sender: TObject);
    procedure ImgMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ImgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure InitSoft;
    procedure lbl_fillpolyClick(Sender: TObject);
    procedure lbl_set_centerClick(Sender: TObject);
    procedure Redraw;
    procedure Erase_Screen;
    procedure Draw_Grid;
    procedure lbl_addbetweenClick(Sender: TObject);
    procedure lbl_addClick(Sender: TObject);
    procedure lbl_deleteClick(Sender: TObject);
    procedure lbl_moveClick(Sender: TObject);
    procedure lbl_ShowGridClick(Sender: TObject);
    procedure lbl_snapClick(Sender: TObject);
    procedure Open_Polygon;
    procedure Open_BackPolygon;
    procedure Save_Polygon;
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;
  SoftVersion             : string;
  GridSnap                : boolean;                     // 1 : snap to grid , 0 : Free
  PolyPts                 : array [0..100] of tpoint;    // Points from the polygon
  Backpoly                : array [0..100] of tpoint;    // point from the back polygon
  PolyCenter              : tpoint;
  NbPoint                 : word;                        // Number of point in the polygon
  NbBkPoint               : word;                        // Number of point in the Back Polygon
  BackPolyLoaded          : Boolean;                     // True if Back Polygon is Loaded
  EditMode                : integer;                     // 0 = new point
                                                         // 1 = move point
                                                         // 2 = add point
                                                         // 3 = delete point
  Zoom                    : integer;                     // Zoom on Picture = 2
  ActX,ActY               : integer;                     // Actual X , Y position from mouse
  PointSelected           : boolean;                     // True if a point is selected
  PointFound              : integer;                     // Point number we found
  PtsSize                 : integer;                     // Size of a point
  SelectedNum             : integer;                     // Number from the selected point
  GridSpace               : integer;                     // Space betwen Grid line
  ShowGrid                : Boolean;                     // Show or hide the grid
  AttractionSpace         : integer;                     // Attraction distance for found a point (in pixels)
  FillPoly                : Boolean;                     // Fill the Polygon if set to True
  Directory               : String;                      // Base directory
  PolyFile                : String;                      // File name
  FileMode                : File of Word;                // File Handle

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  Form1.DoubleBuffered := true;
  Directory := ExtractFilePath(Application.ExeName);
  F_Open.InitialDir := Directory;
  F_Save.InitialDir := Directory;
  InitSoft;
end;

procedure TForm1.InitSoft;
begin
  SoftVersion := 'Polygon Editor v2.0 for ST7Mite MMBasic';
  Form1.Caption := SoftVersion;
  GridSpace := 10;
  ShowGrid := True;
  if BackPolyLoaded = False then
   begin
     BackPolyLoaded := False;
     NbBkPoint := 0;
	 end;
	NbPoint := 0;
  EditMode := 0;
  lbl_add.Color        := $0080FF80;
  lbl_move.Color       := $00D2D2FF;
  lbl_addbetween.Color := $00D2D2FF;
  lbl_delete.Color     := $00D2D2FF;
  GridSnap := False;
  lbl_snap.Color       := $00D2D2FF;
  FillPoly := False;
  lbl_fillpoly.Color   := $00D2D2FF;
  Zoom := 2;
  PointSelected := False;
  PointFound := -1;
  SelectedNum := -1;
  PtsSize := 5;
  AttractionSpace := 5;
  PolyCenter.x := 0;
  PolyCenter.y := 0;
  Erase_Screen;
  Draw_Grid;
end;

procedure TForm1.Redraw;
var
  cnt      : integer;
  ptstmp   : tpoint;
  ptsarray : array [0..100] of tpoint;
  bkptsarray : array [0..100] of tpoint;
begin
  Erase_Screen;
  if (ShowGrid = True) then
   Draw_Grid;

  for cnt := 0 to NbPoint -1 do
   begin
    ptsarray[cnt].x := PolyPts[cnt].x * Zoom;
    ptsarray[cnt].y := PolyPts[cnt].y * Zoom;
	 end;

  if BackPolyLoaded = True then
   begin
     for cnt := 0 to NbBkPoint -1 do
      begin
       bkptsarray[cnt].x := Backpoly[cnt].x * Zoom;
       bkptsarray[cnt].y := Backpoly[cnt].y * Zoom;
			end;
	 end;

  Img.Canvas.Pen.Color := clTeal;
  Img.Canvas.Brush.Color := clGray;
  if BackPolyLoaded = True then
   begin
   	if (NbBkPoint >= 2) then
      if(FillPoly = False) then
       Img.Canvas.PolyLine(bkptsarray ,0, NbBkPoint)
      else
       Img.Canvas.Polygon(bkptsarray,True,0,NbBkPoint);
	 end;
  Img.Canvas.Pen.Color := clYellow;
  Img.Canvas.Brush.Color := clGreen;
	if (NbPoint >= 2) then
   if(FillPoly = False) then
    Img.Canvas.PolyLine(ptsarray ,0, NbPoint)
   else
    Img.Canvas.Polygon(ptsarray,True,0,NbPoint);

  Img.Canvas.Pen.Color := clRed;
  Img.Canvas.Brush.Color := clBlue;
  for cnt := 0 to NbPoint -1 do
   begin
    // Draw all point
    ptstmp.x := PolyPts[cnt].x * Zoom;
    ptstmp.y := PolyPts[cnt].y * Zoom;
    Img.Canvas.Ellipse(ptstmp.x - PtsSize , ptstmp.y - PtsSize , ptstmp.x + PtsSize , ptstmp.y + PtsSize);
    Img.Canvas.FloodFill(ptstmp.x,ptstmp.y,clblue,fssurface);
   end;

  // Draw the Center point
  Img.Canvas.Pen.Color := clYellow;
  Img.Canvas.Brush.Color := clRed;
  ptstmp.x := PolyCenter.x * Zoom;
  ptstmp.y := PolyCenter.y * Zoom;
  Img.Canvas.Ellipse(ptstmp.x - PtsSize , ptstmp.y - PtsSize , ptstmp.x + PtsSize , ptstmp.y + PtsSize);
  Img.Canvas.FloodFill(ptstmp.x,ptstmp.y,clblue,fssurface);

  lbl_NbPoint.Caption := inttostr(NbPoint);
end;

procedure TForm1.Btn_LoadClick(Sender: TObject);
begin
  // Load a Polygon from file
  F_Open.Title       := 'Load a Polygon';
  F_Open.Filter := 'Polygon File|*.pol';
  F_Open.FilterIndex := 1;
  F_Open.Execute;
  PolyFile := F_Open.FileName;
  if PolyFile = '' then
   PolyFile := Directory + '\dummy.pol';
  if PolyFile <> (Directory + '\dummy.pol') then
   Open_Polygon;
end;

procedure TForm1.Btn_BackClick(Sender: TObject);
begin
  // Load a Background Polygon from file
  F_Open.Title       := 'Load a Polygon';
  F_Open.Filter := 'Polygon File|*.pol';
  F_Open.FilterIndex := 1;
  F_Open.Execute;
  PolyFile := F_Open.FileName;
  if PolyFile = '' then
   PolyFile := Directory + '\dummy.pol';
  if PolyFile <> (Directory + '\dummy.pol') then
   Open_BackPolygon;
end;

procedure TForm1.Btn_SaveClick(Sender: TObject);
begin
  // Save a Polygon to file
  F_Save.Title       := 'Save a Polygon';
  F_Save.Filter := 'Polygon File|*.pol';
  F_Save.FilterIndex := 1;
  F_Save.Execute;
  PolyFile := F_Save.FileName;
  if PolyFile = '' then
   PolyFile := Directory + '\dummy.pol';
  if PolyFile <> Directory + '\dummy.pol' then
  begin
   Save_Polygon;
  end;
end;

procedure TForm1.Btn_ResetClick(Sender: TObject);
begin
  // Reset Everything
  InitSoft;
end;

procedure TForm1.ImgClick(Sender: TObject);
var
  cnt      : integer;
begin
  // Edit Mode 0 , add a new point
  if(EditMode = 0) then
   begin
     if (NbPoint < 100) then
      begin
       NbPoint := NbPoint + 1;
       PolyPts[NbPoint - 1].x := ActX;
       PolyPts[NbPoint - 1].y := ActY;
      end;
     Redraw;
   end;

  // Edit Mode 1 , move a point
  if(EditMode = 1) then
   begin
     if(PointSelected = True) then
      begin
        PolyPts[SelectedNum].x := ActX;
        PolyPts[SelectedNum].y := ActY;
        Redraw;
        EditMode := 0;
        PointSelected := False;
        SelectedNum := -1;
        lbl_add.Color        := $0080FF80;
        lbl_move.Color       := $00D2D2FF;
        lbl_addbetween.Color := $00D2D2FF;
        lbl_delete.Color     := $00D2D2FF;
        lbl_set_center.Color := $00D2D2FF;
      end
     else
      begin
       if(PointFound <> -1) then
        begin
          PointSelected := True;
          SelectedNum := PointFound;
        end;
      end;
   end;

  // Edit Mode 2 , add a point between other points
  if(EditMode = 2) and (PointFound <> -1) and (PointFound < NbPoint) then
   begin
     for cnt := NbPoint downto (PointFound + 1) do
       PolyPts[cnt] := PolyPts[cnt - 1];

     if(PolyPts[PointFound].x < PolyPts[PointFound + 2].x) then
      PolyPts[PointFound + 1].x := PolyPts[PointFound].x + round((PolyPts[PointFound + 2].x - PolyPts[PointFound].x) / 2)
     else
      PolyPts[PointFound + 1].x := PolyPts[PointFound].x - round((PolyPts[PointFound].x - PolyPts[PointFound + 2].x) / 2);

     if(PolyPts[PointFound].y < PolyPts[PointFound + 2].y) then
      PolyPts[PointFound + 1].y := PolyPts[PointFound].y + round((PolyPts[PointFound + 2].y - PolyPts[PointFound].y) / 2)
     else
      PolyPts[PointFound + 1].y := PolyPts[PointFound].y - round((PolyPts[PointFound].y - PolyPts[PointFound + 2].y) / 2);

     NbPoint := NbPoint + 1;
     Redraw;
     EditMode := 0;
     PointSelected := False;
     SelectedNum := -1;
     lbl_add.Color        := $0080FF80;
     lbl_move.Color       := $00D2D2FF;
     lbl_addbetween.Color := $00D2D2FF;
     lbl_delete.Color     := $00D2D2FF;
     lbl_set_center.Color := $00D2D2FF;
   end;

  // Edit Mode 3 , delete a point
  if(EditMode = 3) then
   begin
     if(PointFound <> -1) then
      begin
        for cnt := PointFound to NbPoint -1 do
          PolyPts[cnt] := PolyPts[cnt + 1];
        NbPoint := NbPoint - 1;
        Redraw;
        EditMode := 0;
        PointSelected := False;
        SelectedNum := -1;
        lbl_add.Color        := $0080FF80;
        lbl_move.Color       := $00D2D2FF;
        lbl_addbetween.Color := $00D2D2FF;
        lbl_delete.Color     := $00D2D2FF;
        lbl_set_center.Color := $00D2D2FF;
      end;
   end;

  // Edit Mode 4 , Polygon Center
  if(EditMode = 4) then
   begin
     PolyCenter.x := ActX;
     PolyCenter.y := ActY;
     Redraw;
     EditMode := 0;
     PointSelected := False;
     SelectedNum := -1;
     lbl_add.Color        := $0080FF80;
     lbl_move.Color       := $00D2D2FF;
     lbl_addbetween.Color := $00D2D2FF;
     lbl_delete.Color     := $00D2D2FF;
     lbl_set_center.Color := $00D2D2FF;
   end;

end;

procedure TForm1.ImgMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button = mbRight) then
   begin
     // Right Button = Move Point Mode
     EditMode := 1;
     lbl_add.Color        := $00D2D2FF;
     lbl_move.Color       := $0080FF80;
     lbl_addbetween.Color := $00D2D2FF;
     lbl_delete.Color     := $00D2D2FF;
   end;
end;

procedure TForm1.ImgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var
  cnt      : integer;
  ptstmp   : tpoint;
begin
  if GridSnap = False then
   begin
     // Get X,Y real coordinate
     if(X >= 0) then
      ActX := round(X / Zoom)
     else
      ActX := 0;
     if(Y >= 0) then
      ActY := round(Y / Zoom)
     else
      ActY := 0;
     if (ActX > 479) then ActX := 479;
     if (ActY > 271) then ActY := 271;
   end
  else
   begin
    // Get X,Y real coordinate with Grid snap
    if(x >= 0) then
     ActX := round(X / Zoom / GridSpace) * GridSpace
    else
     ActX := 0;
    if(y >= 0) then
     ActY := round(Y / Zoom / GridSpace) * GridSpace
    else
     ActY := 0;
    if (ActX > 479) then ActX := ActX - GridSpace;
    if (ActY > 271) then ActY := ActY - GridSpace;
   end;

   // Find a point close to this coordinate
   PointFound := -1;
   for cnt := 0 to NbPoint -1 do
    begin
     if((ActX + AttractionSpace) >= PolyPts[cnt].x) and
       ((ActX - AttractionSpace) <= PolyPts[cnt].x) and
       ((ActY + AttractionSpace) >= PolyPts[cnt].y) and
       ((ActY - AttractionSpace) <= PolyPts[cnt].y) then
        begin
          ptstmp.x := PolyPts[cnt].x * Zoom;
          ptstmp.y := PolyPts[cnt].y * Zoom;
          Img.Canvas.Pen.Color := clYellow;
          PointFound := cnt;
        end;
    end;
   if (PointFound <> -1) and (EditMode <> 2) then
    Img.Canvas.Ellipse(ptstmp.x - (PtsSize + 2) , ptstmp.y - (PtsSize + 2) , ptstmp.x + (PtsSize + 2) , ptstmp.y + (PtsSize + 2))
   else if (PointFound <> -1) and (EditMode = 2) and (PointFound < NbPoint) then
    begin
      Img.Canvas.Ellipse(ptstmp.x - (PtsSize + 2) , ptstmp.y - (PtsSize + 2) , ptstmp.x + (PtsSize + 2) , ptstmp.y + (PtsSize + 2));
      ptstmp.x := PolyPts[PointFound + 1].x * Zoom;
      ptstmp.y := PolyPts[PointFound + 1].y * Zoom;
      Img.Canvas.Ellipse(ptstmp.x - (PtsSize + 2) , ptstmp.y - (PtsSize + 2) , ptstmp.x + (PtsSize + 2) , ptstmp.y + (PtsSize + 2))
    end
   else
    Redraw;

   if(EditMode = 1) then
    begin
      if(PointSelected = True) then
       begin
         PolyPts[SelectedNum].x := ActX;
         PolyPts[SelectedNum].y := ActY;
         Redraw;
       end;
    end;



   lbl_X.Caption := inttostr(ActX);
   lbl_Y.Caption := inttostr(ActY);
end;

procedure TForm1.Erase_Screen;
begin
  Img.Canvas.Brush.Color  := clBlack;
  Img.Canvas.FillRect (rect(0,0,Img.ClientWidth ,Img.ClientHeight ));
end;

procedure TForm1.Draw_Grid;
var
  cntx,cnty                : integer;
  GridSpacing              : integer;
begin
  cntx := 0; cnty := 0;
  GridSpacing := GridSpace * Zoom;
  Img.Canvas.Pen.Color := clGray;
  while cntx < Img.ClientWidth do
  begin
    Img.Canvas.Line(cntx,0,cntx,Img.ClientHeight);
    cntx := cntx + GridSpacing;
  end;
  while cnty < Img.ClientHeight do
  begin
    Img.Canvas.Line(0,cnty,Img.ClientWidth,cnty);
    cnty := cnty + GridSpacing;
  end;
end;

procedure TForm1.lbl_ShowGridClick(Sender: TObject);
begin
  // Show or hide the Grid
  if(ShowGrid = True) then
   begin
     ShowGrid := False;
     lbl_ShowGrid.Color := $00D2D2FF;
     GridSnap := False;
     lbl_snap.Color := $00D2D2FF;
     lbl_snap.Visible := False;
   end
  else
   begin
     ShowGrid := True;
     lbl_ShowGrid.Color := $0080FF80;
     lbl_snap.Visible := True;
   end;
  Redraw;
end;

procedure TForm1.lbl_addClick(Sender: TObject);
begin
  // Edit Mode 0 , add a new point
  EditMode := 0;
  lbl_add.Color        := $0080FF80;
  lbl_move.Color       := $00D2D2FF;
  lbl_addbetween.Color := $00D2D2FF;
  lbl_delete.Color     := $00D2D2FF;
  lbl_set_center.Color := $00D2D2FF;
end;

procedure TForm1.lbl_moveClick(Sender: TObject);
begin
  // Edit Mode 1 , move a point
  EditMode := 1;
  lbl_add.Color        := $00D2D2FF;
  lbl_move.Color       := $0080FF80;
  lbl_addbetween.Color := $00D2D2FF;
  lbl_delete.Color     := $00D2D2FF;
  lbl_set_center.Color := $00D2D2FF;
end;

procedure TForm1.lbl_addbetweenClick(Sender: TObject);
begin
  // Edit Mode 2 , add a point between other points
  EditMode := 2;
  lbl_add.Color        := $00D2D2FF;
  lbl_move.Color       := $00D2D2FF;
  lbl_addbetween.Color := $0080FF80;
  lbl_delete.Color     := $00D2D2FF;
  lbl_set_center.Color := $00D2D2FF;
end;

procedure TForm1.lbl_deleteClick(Sender: TObject);
begin
  // Edit Mode 3 , delete a point
  EditMode := 3;
  lbl_add.Color        := $00D2D2FF;
  lbl_move.Color       := $00D2D2FF;
  lbl_addbetween.Color := $00D2D2FF;
  lbl_delete.Color     := $0080FF80;
  lbl_set_center.Color := $00D2D2FF;
end;

procedure TForm1.lbl_set_centerClick(Sender: TObject);
begin
  // Set center point from the Polygon
  EditMode := 4;
  lbl_add.Color        := $00D2D2FF;
  lbl_move.Color       := $00D2D2FF;
  lbl_addbetween.Color := $00D2D2FF;
  lbl_delete.Color     := $00D2D2FF;
  lbl_set_center.Color := $0080FF80;
end;

procedure TForm1.lbl_snapClick(Sender: TObject);
begin
  // Snap to grid
  if GridSnap = True then
   begin
     GridSnap := False;
     lbl_snap.Color := $00D2D2FF;
   end
  else
   begin
     GridSnap := True;
     lbl_snap.Color := $0080FF80;
   end;
end;

procedure TForm1.lbl_fillpolyClick(Sender: TObject);
begin
 // Fill polygon
  if FillPoly = True then
   begin
     FillPoly := False;
     lbl_fillpoly.Color := $00D2D2FF;
     Redraw;
   end
  else
   begin
     FillPoly := True;
     lbl_fillpoly.Color := $0080FF80;
     Redraw;
   end;
end;

procedure TForm1.Open_Polygon;
var
  cnt      : integer;
  px,py    : word;
begin
  // Load the Polygon
  AssignFile(FileMode,PolyFile);
  Reset(FileMode);
  // Init the soft before read the file data
  InitSoft;
  // Get number of point for this polygon
  Read(FileMode,NbPoint);
  // Get the center X,Y from the polygon
  Read(FileMode,px);
  PolyCenter.x := px;
  Read(FileMode,py);
  PolyCenter.y := py;
  // Get all the polygon point
  for cnt := 0 to NbPoint -1 do
  begin
   Read(FileMode,px);
   PolyPts[cnt].x := px;
   Read(FileMode,py);
   PolyPts[cnt].y := py;
  end;
  CloseFile(FileMode);
  Redraw;
end;

procedure TForm1.Open_BackPolygon;
var
  cnt      : integer;
  px,py    : word;
begin
  // Load the Polygon
  AssignFile(FileMode,PolyFile);
  Reset(FileMode);
  // Get number of point for the back polygon
  Read(FileMode,NbBkPoint);
  // Get the center X,Y from the back polygon (Not used)
  Read(FileMode,px);
  Read(FileMode,py);
  // Get all the back polygon point
  for cnt := 0 to NbBkPoint -1 do
  begin
   Read(FileMode,px);
   Backpoly[cnt].x := px;
   Read(FileMode,py);
   Backpoly[cnt].y := py;
  end;
  CloseFile(FileMode);
  // Set the Back Polygon as loaded
  BackPolyLoaded := True;
  Redraw;
end;

procedure TForm1.Save_Polygon;
var
  cnt      : integer;
  px,py    : word;
begin
  // Save the Polygon
  // File format :
  //     Number of point     : 1 word
  //     Coord Center X      : 1 word
  //     Coord Center Y      : 1 word
  //     Coord X pts 0       : 1 word
  //     Coord Y pts 0       : 1 word
  //     Coord x pts ...
  //     Coord Y pts ...
  //     Coord X last point  : 1 word
  //     Coord Y last point  : 1 word
  AssignFile(FileMode,PolyFile);
  Rewrite(FileMode);
  // Write number of points
  write(FileMode,NbPoint);
  // Write Center X,Y
  px := PolyCenter.x;
  py := PolyCenter.y;
  write(FileMode,px);
  write(FileMode,py);
  // Write all Point to File
  for cnt := 0 to NbPoint -1 do
  begin
   px := PolyPts[cnt].x;
   py := PolyPts[cnt].y;
   write(FileMode,px);
   write(FileMode,py);
  end;
  CloseFile(FileMode);
end;

end.

