unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls, variables, procedures;

type

  { TForm1 }

  TForm1 = class(TForm)
    ButtReset: TButton;
    ButtSaveBin: TButton;
    ButtOpen: TButton;
    Img: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Lbl_Pts: TLabel;
    Lbl_Face: TLabel;
    OpenFile: TOpenDialog;
    Panel1: TPanel;
    SaveFile: TSaveDialog;
    ScrZoom: TScrollBar;
    ScrRX: TScrollBar;
    ScrTX: TScrollBar;
    ScrRY: TScrollBar;
    ScrTY: TScrollBar;
    ScrRZ: TScrollBar;
    ScrTZ: TScrollBar;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure ImgMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ImgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure ImgMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ImgMouseWheelDown(Sender: TObject; Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
    procedure ImgMouseWheelUp(Sender: TObject; Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
    procedure Init_Var;
    procedure ButtResetClick(Sender: TObject);
    procedure ButtSaveBinClick(Sender: TObject);
    procedure ButtOpenClick(Sender: TObject);
    procedure Clear_Image;
    procedure Redraw;
    procedure ScrZoomChange(Sender: TObject);
    procedure ScrRXChange(Sender: TObject);
    procedure ScrRYChange(Sender: TObject);
    procedure ScrRZChange(Sender: TObject);
    procedure ScrTXChange(Sender: TObject);
    procedure ScrTYChange(Sender: TObject);
    procedure affiche3D(nb : Integer);
    procedure Save_Bin_File;

  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;
  oldx , oldy   : integer;
  dox,doy,doz   : integer;
  mdown         : integer;
implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  Form1.DoubleBuffered := true;
  DecimalSeparator:='.';                                // Define the point as decimal separator
  Directory := ExtractFilePath(Application.ExeName);    // Application directory
  Clear_Image;
  Init_Var;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  if (Form1.Width < 555) then Form1.Width := 555;
  if (Form1.Height < 535) then Form1.Height := 535;
  img.Width := Form1.Width - 12;
  img.Height := Form1.Height - 135;
  img.Picture.Bitmap.Width:=img.Width;
  img.Picture.Bitmap.Height:=img.Height;
  Redraw;
end;

procedure TForm1.ImgMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  mdown := 1;
  oldx := x;
  oldy := y;
end;

procedure TForm1.ImgMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  if mdown = 1 then
   begin
     doy := ScrRY.Position + (x - oldx);
     dox := ScrRX.Position + (y - oldy);
     if dox > ScrRX.Max then dox := 0;
     if dox < 0 then dox := 360 - dox;
     if doy > ScrRY.Max then doy := 0;
     if doy < 0 then doy := 360 - doy;
     ScrRY.Position := doy;
     ScrRX.Position := dox;
     oldx := x;
     oldy := y;
   end;
end;

procedure TForm1.ImgMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  mdown := 0;
end;

procedure TForm1.ImgMouseWheelDown(Sender: TObject; Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
begin
  ScrZoom.Position := ScrZoom.Position - 1 ;
end;

procedure TForm1.ImgMouseWheelUp(Sender: TObject; Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
begin
  ScrZoom.Position := ScrZoom.Position + 1 ;
end;

procedure TForm1.Init_Var;
begin
  ScrRX.Position := 0;
  ScrRY.Position := 0;
  ScrRZ.Position := 0;
  ScrTX.Position := 0;
  ScrTY.Position := 0;
  ScrZoom.Position := 10;
  Clear_Image;
  nbp :=  0;
  nbf :=  0;
  nbf2 := 0;
  zoom := 1.0;
  File_Loaded := 0;
end;

procedure TForm1.ButtOpenClick(Sender: TObject);
begin
  // Set the File from where we load the Sprites (New file system)
  OpenFile.Title        := 'Load a 3DS ASC file';
  OpenFile.Filter       := '3DS ASC file|*.asc';
  OpenFile.FilterIndex  := 1;
  OpenFile.Execute;
  ObjectFile := OpenFile.FileName;
  if ObjectFile = '' then
   ObjectFile := Directory + '\dummy.asc';
  if ObjectFile <> (Directory + '\dummy.asc') then
   begin
     Init_Var;
     decodeASC(ObjectFile);
     Lbl_Pts.Caption := inttostr(nbp);
     Lbl_Face.Caption := inttostr(nbf);
     Redraw;
   end;
end;

procedure TForm1.ButtSaveBinClick(Sender: TObject);
begin
  // Save the 3D Object
  if File_Loaded = 1 then
   begin
     SaveFile.Title  := 'Save a 3D Binary File';
     SaveFile.Filter := '3D Binary File|*.b3d';
     SaveFile.FilterIndex := 1;
     SaveFile.Execute;
     BinFileName := SaveFile.FileName;
     if BinFileName = '' then
      BinFileName := Directory + '\dummy.b3d';
     if BinFileName <> Directory + '\dummy.b3d' then
       begin
         Save_Bin_File;
       end
     else
     ShowMessage('!! Wrong file name !!');
   end
  else
  ShowMessage('!! Nothing to Save !!');
end;

procedure TForm1.ButtResetClick(Sender: TObject);
begin
  Init_Var;
  ScrRX.Position := 0;
  ScrRY.Position := 0;
  ScrRZ.Position := 0;
  ScrTX.Position := 0;
  ScrTY.Position := 0;
  ScrZoom.Position := 10;
  Clear_Image;
end;

procedure TForm1.Clear_Image;
begin
  Img.Canvas.Brush.Color  := clBlack;
  Img.Canvas.FillRect (rect(0,0,Img.ClientWidth ,Img.ClientHeight ));
end;

procedure TForm1.Redraw;
begin
  if File_Loaded = 1 then
   begin
     rx := ScrRX.Position;
     ry := ScrRY.Position;
     rz := ScrRZ.Position;
     tx := ScrTX.Position;
     ty := ScrTY.Position;
     tz := 0;
     zoom := ScrZoom.Position / 10;
     Clear_Image;
     Calcul3D(1, nbp, rx, ry, rz, tx, ty, tz);
     cache3D(nbf);
     affiche3D(nbf2);
   end;
end;

procedure TForm1.ScrZoomChange(Sender: TObject);
begin
  zoom := ScrZoom.Position / 10;
  Redraw;
end;

procedure TForm1.ScrRXChange(Sender: TObject);
begin
  rx := ScrRX.Position;
  Redraw;
end;

procedure TForm1.ScrRYChange(Sender: TObject);
begin
  ry := ScrRY.Position;
  Redraw;
end;

procedure TForm1.ScrRZChange(Sender: TObject);
begin
  rz := ScrRZ.Position;
  Redraw;
end;

procedure TForm1.ScrTXChange(Sender: TObject);
begin
  tx := ScrTX.Position;
  Redraw;
end;

procedure TForm1.ScrTYChange(Sender: TObject);
begin
  ty := ScrTY.Position;
  Redraw;
end;

procedure TForm1.affiche3D(nb : Integer);
var
  points      : array[0..2] of TPoint;
  a           : LongInt;
begin
  cx := round(Img.ClientWidth / 2);
  cy := round(Img.ClientHeight / 2);
  Img.Canvas.Brush.Color := clGreen;
  Img.Canvas.Pen.Color := clYellow;
  for a := 1 to nb do
      begin
      points[0].x := round(pts2[facevue[a].p1].x + cx);
      points[0].y := round(pts2[facevue[a].p1].y + cy);
      points[1].x := round(pts2[facevue[a].p2].x + cx);
      points[1].y := round(pts2[facevue[a].p2].y + cy);
      points[2].x := round(pts2[facevue[a].p3].x + cx);
      points[2].y := round(pts2[facevue[a].p3].y + cy);
      Img.Canvas.Polygon([points[0],points[1],points[2]]);
      end;
end;

procedure TForm1.Save_Bin_File;
var
  cnt                      : LongInt;
  px,py,pz                 : LongInt;
begin
  // Here we save the object in a binary file
  //
  // 3D Binary file format:
  // nnn                      : number of points from 1 to nbp
  // nnn                      : number of faces from 1 to nbf
  // nn...                    : all points
  // nn...                    : all faces
  AssignFile(File_Bin,BinFileName);
  Rewrite(File_Bin);
  write(File_Bin,nbp);
  write(File_Bin,nbf);
  for cnt := 1 to nbp do
    begin
      px := round(pts[cnt].x * 10000);
      py := round(pts[cnt].y * 10000);
      pz := round(pts[cnt].z * 10000);
      write(File_Bin,px);
      write(File_Bin,py);
      write(File_Bin,pz);
    end;
  for cnt := 1 to nbf do
    begin
      write(File_Bin,face[cnt].p1);
      write(File_Bin,face[cnt].p2);
      write(File_Bin,face[cnt].p3);
    end;
  CloseFile(File_Bin);
  ShowMessage('File Saved');
end;






end.

