unit procedures;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls, variables, math;


procedure Calcul3D(pt1 : Integer; pt2 : Integer; ax : Single; ay : Single; az : Single; ptrx : Single; ptry : Single; ptrz : Single);
procedure zbuffer(nb : Integer);
procedure cache3D(nb : Integer);
procedure decodeASC(nom : String);
procedure decodeASCpoints(f : String);
procedure decodeASCfaces(f : String);

implementation

procedure Calcul3D(pt1 : Integer; pt2 : Integer; ax : Single; ay : Single; az : Single; ptrx : Single; ptry : Single; ptrz : Single);
var
  a               : integer;
begin
  ax := ax * degree;
  ay := ay * degree;
  az := az * degree;
  //       Calculs des Rotation X,Y,Z
  For a := pt1 To pt2 do
    begin
      //   Rotation sur Axe X
      tmpy := pts[a].y * Cos(ax) - pts[a].z * Sin(ax);
      tmpz := pts[a].y * Sin(ax) + pts[a].z * Cos(ax);
      pts2[a].y := tmpy;
      pts2[a].z := tmpz;
      //   Rotation sur Axe Z
      tmpx := pts[a].x * Cos(az) - pts2[a].y * Sin(az);
      tmpy := pts[a].x * Sin(az) + pts2[a].y * Cos(az);
      pts2[a].x := tmpx;
      pts2[a].y := tmpy;
      //   Rotation sur Axe X
      tmpx := pts2[a].x * Cos(ay) - pts2[a].z * Sin(ay);
      tmpz := pts2[a].x * Sin(ay) + pts2[a].z * Cos(ay);
      pts2[a].x := tmpx;
      pts2[a].z := tmpz;
    end;

  //       Calculs des Translations X,Y,Z
  For a := pt1 To pt2 do
    begin
      pts2[a].x := (pts2[a].x * zoom) + ptrx;
      pts2[a].y := (pts2[a].y * zoom) + ptry;
      pts2[a].z := (pts2[a].z * zoom) + ptrz;
    end;
end;

procedure zbuffer(nb : Integer);
var
  tmpz1 : Single;
  tmpf  : Fce;
  a,b   : LongInt;
begin
  SetLength( zbuff1, nbf + 1);
  //    Calcul de la valeur Z de chaque face
  For a := 1 To nb do
     zbuff1[a] := (pts2[facevue[a].p1].z + pts2[facevue[a].p2].z + pts2[facevue[a].p3].z) / 3;
  //    Classer les face par odre de priorité croissante
  For a := 1 To nb - 1 do
    For b := a + 1 To nb do
        If zbuff1[b] < zbuff1[a] Then
          begin
           tmpz1 := zbuff1[a];
           tmpf.p1 := facevue[a].p1;
           tmpf.p2 := facevue[a].p2;
           tmpf.p3 := facevue[a].p3;
           zbuff1[a] := zbuff1[b];
           zbuff1[b] := tmpz1;
           facevue[a].p1 := facevue[b].p1;
           facevue[a].p2 := facevue[b].p2;
           facevue[a].p3 := facevue[b].p3;
           facevue[b].p1 := tmpf.p1;
           facevue[b].p2 := tmpf.p2;
           facevue[b].p3 := tmpf.p3;
          end;
end;

procedure cache3D(nb : Integer);
var
  vecteur : Single;
  v1 : Single;
  v2 : Single;
  v3 : Single;
  v4 : Single;
  a  : LongInt;
begin
  SetLength( facevue, nb + 1);
  nbf2 := 0;
  For a := 1 To nb do
    begin
     v1 := pts2[face[a].p1].x - pts2[face[a].p2].x;
     v2 := pts2[face[a].p3].y - pts2[face[a].p2].y;
     v3 := pts2[face[a].p3].x - pts2[face[a].p2].x;
     v4 := pts2[face[a].p1].y - pts2[face[a].p2].y;
     vecteur := (v1 * v2) - (v3 * v4);
     If vecteur < 0 Then
        begin
        inc(nbf2);
        facevue[nbf2].p1 := face[a].p1;
        facevue[nbf2].p2 := face[a].p2;
        facevue[nbf2].p3 := face[a].p3;
        end;
    end;
  zbuffer(nbf2);
end;

procedure decodeASC(nom : String);
var
    StartSearch   : Integer;
    EndSearch     : Integer;
    TempString    : String;
    DataLine      : string;
    Cnt           : LongInt;
begin
  // Here we only decode the file header to get
  // the number of Points and Faces to read.
  // The header show like this :
  //Ambient light color: Red=0.0431 Green=0.0431 Blue=0.0431
  //
  //Named object: "objet001"
  //Tri-mesh, Vertices: 509     Faces: 1014
  //Vertex list:

  //'Some variable will be initialized here
  StartSearch := 0;
  EndSearch   := 0;
  //'Here we read and count how much points and faces we have
  AssignFile(File_Text,ObjectFile);
  Reset(File_Text);

  // We have to find the 'Tri-mesh' string first
  While Not EOF(File_Text) do
    begin
      ReadLn(File_Text,DataLine);
      DataLine := upcase(DataLine);
      // First we have to ignore all header data
      If InStr(1, DataLine, 'TRI-MESH') > 0 Then
         begin
            // We found 'Tri-Mesh' , we have to get the
            // number of points and faces in this line
            // Search the first ':' for get the Points count
           StartSearch := InStr(1, DataLine, ':');
           StartSearch := StartSearch + 1;               //'":" = 1 char
           //'now we look char after char up we get something <> than a space
           Cnt := StartSearch;
           while (cnt < Length(DataLine)) do
             begin
               If Mid(DataLine, Cnt, 1) <> ' ' Then
                 begin
                   StartSearch := Cnt; //'here we got the start of the Point count
                   cnt := Length(DataLine);
                 end;
               inc(cnt);
             end;
           //'We look char after char up we get  a space
           Cnt := StartSearch + 1;
           while (cnt < Length(DataLine)) do
             begin
               If Mid(DataLine, Cnt, 1) = ' ' Then
                 begin
                   EndSearch := Cnt - 1; //'here we got the end for points count
                   cnt := Length(DataLine);
                 end;
               inc(cnt);
             end;
           //'We can record the number of point
           TempString := RightTrim(LeftTrim(Mid(DataLine, StartSearch, EndSearch - StartSearch + 1)));
           nbp := strtoint(TempString);

           //'We actualize the StartSearch variable for get number of Faces
           StartSearch := EndSearch + 1;
           cnt := StartSearch;
           //'And we do the same for the number of points
           // Search for the next ':'
            while (cnt < Length(DataLine)) do
             begin
               If Mid(DataLine, Cnt, 1) = ':' Then
                 begin
                   StartSearch := Cnt; //'here we got the start of the Face count
                   cnt := Length(DataLine);
                 end;
               inc(cnt);
             end;
            StartSearch := StartSearch + 1;
            // We get all rest chars in the line
            EndSearch := Length(DataLine);
            TempString := RightTrim(LeftTrim(Mid(DataLine, StartSearch, EndSearch - StartSearch + 1)));
            nbf := strtoint(TempString);
         end;
    end;
  CloseFile(File_Text);
  //If we have found a Points and Faces in the ASC File we can
  //Read all Points and Faces from the file
  If (nbp > 0) And (nbf > 0) Then
    begin
       SetLength( pts,  nbp + 1);
       SetLength( pts2, nbp + 1);
       SetLength( face, nbf + 1);
       decodeASCpoints(nom);
       decodeASCfaces(nom);
       File_Loaded := 1;
       ShowMessage('File Loaded');
    end;
end;

procedure decodeASCpoints(f : String);
var
    StartSearch   : Integer;
    EndSearch     : Integer;
    TempString    : String;
    DataLine      : string;
    Cnt           : LongInt;
    NumPoint      : LongInt;
    expo          : byte;
begin
  // Sart after :
  // Vertex list:
  // One points line is like this :
  // Vertex 0:  X:0.0000     Y:-40.0000     Z:40.0000
  // TAKE CARE !! WE TAKE POINT FROM 1 TO nbp WE DONT START AT 0 !!!
  StartSearch := 0;
  EndSearch   := 0;
  NumPoint    := 0;
  AssignFile(File_Text,ObjectFile);
  Reset(File_Text);
  While Not EOF(File_Text) do
    begin
      ReadLn(File_Text,DataLine);
      DataLine := upcase(DataLine);
      // Look for 'Vertex' and not 'Vertex list'
      If ((InStr(1, DataLine, 'VERTEX') > 0) and (InStr(1, DataLine, 'VERTEX LIST') = 0)) Then
        begin
           inc(NumPoint);
           // Search 'X:'
           Cnt := InStr(1, DataLine, 'X:');
           StartSearch := Cnt + 2;            // 'X:' is 2 char
           // From here we search the next space or exponent
           Cnt := StartSearch + 1;
           expo := 0;
           while (cnt < Length(DataLine)) do
             begin
               If ((Mid(DataLine, Cnt, 1) = ' ') or (Mid(DataLine, Cnt, 1) = 'E') or (Mid(DataLine, Cnt, 1) = chr(9))) Then
                 begin
                   EndSearch := Cnt - 1; //'here we got the end for X Coordinate
                   cnt := Length(DataLine);
                   if (Mid(DataLine, Cnt, 1) = 'E') then expo := 1;
                 end;
               inc(cnt);
             end;
           //'We can record the X Coordinate
           if expo = 0 then
             begin
               TempString := RightTrim(LeftTrim(Mid(DataLine, StartSearch, EndSearch - StartSearch + 1)));
               pts[NumPoint].x := strtofloat(TempString);
             end
           else
               pts[NumPoint].x := 0.0;


            // Search 'Y:'
           Cnt := InStr(1, DataLine, 'Y:');
           StartSearch := Cnt + 2;            // 'Y:' is 2 char
           // From here we search the next space or exponent
           Cnt := StartSearch + 1;
           expo := 0;
           while (cnt < Length(DataLine)) do
             begin
               If ((Mid(DataLine, Cnt, 1) = ' ') or (Mid(DataLine, Cnt, 1) = 'E') or (Mid(DataLine, Cnt, 1) = chr(9))) Then
                 begin
                   EndSearch := Cnt - 1; //'here we got the end for Y Coordinate
                   cnt := Length(DataLine);
                   if (Mid(DataLine, Cnt, 1) = 'E') then expo := 1;
                 end;
               inc(cnt);
             end;
           //'We can record the Y Coordinate
          if expo = 0 then
            begin
              TempString := RightTrim(LeftTrim(Mid(DataLine, StartSearch, EndSearch - StartSearch + 1)));
              pts[NumPoint].y := strtofloat(TempString);
            end
          else
              pts[NumPoint].y := 0.0;

           // Search 'Z:'
          Cnt := InStr(1, DataLine, 'Z:');
          StartSearch := Cnt + 2;            // 'Z:' is 2 char
          // We get all rest chars in the line
          EndSearch := Length(DataLine);
          TempString := RightTrim(LeftTrim(Mid(DataLine, StartSearch, EndSearch - StartSearch + 1)));
          if (InStr(1, TempString, 'E') > 0) then
            pts[NumPoint].z := 0.0
          else
            pts[NumPoint].z := strtofloat(TempString);
        end;
    end;
  CloseFile(File_Text);
end;

procedure decodeASCfaces(f : String);
var
    StartSearch   : Integer;
    EndSearch     : Integer;
    TempString    : String;
    DataLine      : string;
    Cnt           : LongInt;
    NumFace       : LongInt;
begin
  // Start after :
  // Face list:
  // One face line is like this :
  //Face 0:    A:0 B:1 C:2 AB:1 BC:1 CA:1
  // TAKE CARE !! WE HAVE TO ADD 1 TO THE POINT NUMBER , WE DONT START FROM 0 !!
  // FACE NUMBER START FROM 1 , NOT FROM 0 !!
  StartSearch := 0;
  EndSearch   := 0;
  NumFace     := 0;
  AssignFile(File_Text,ObjectFile);
  Reset(File_Text);
  While Not EOF(File_Text) do
    begin
      ReadLn(File_Text,DataLine);
      DataLine := upcase(DataLine);
      // Look for 'Face' and not 'Face list' and not 'Tri-mesh'
      If ((InStr(1, DataLine, 'FACE') > 0) and (InStr(1, DataLine, 'FACE LIST') = 0)  and (InStr(1, DataLine, 'TRI-MESH') = 0)) Then
        begin
          inc(NumFace);
          // Search 'A:'
          Cnt := InStr(1, DataLine, 'A:');
          StartSearch := Cnt + 2;            // 'A:' is 2 char
          // From here we search the next space
          Cnt := StartSearch + 1;
          while (cnt < Length(DataLine)) do
            begin
              If ((Mid(DataLine, Cnt, 1) = ' ')  or (Mid(DataLine, Cnt, 1) = chr(9))) Then
                begin
                  EndSearch := Cnt - 1; //'here we got the end for 1st Point in face
                  cnt := Length(DataLine);
                end;
              inc(cnt);
            end;
          //'We can record the X Coordinate
          TempString := RightTrim(LeftTrim(Mid(DataLine, StartSearch, EndSearch - StartSearch + 1)));
          face[NumFace].p1 := strtoint(TempString) + 1;

          // Search 'B:'
          Cnt := InStr(1, DataLine, 'B:');
          StartSearch := Cnt + 2;            // 'B:' is 2 char
          // From here we search the next space
          Cnt := StartSearch + 1;
          while (cnt < Length(DataLine)) do
            begin
              If ((Mid(DataLine, Cnt, 1) = ' ')  or (Mid(DataLine, Cnt, 1) = chr(9))) Then
                begin
                  EndSearch := Cnt - 1; //'here we got the end for 2nd Point in face
                  cnt := Length(DataLine);
                end;
              inc(cnt);
            end;
          //'We can record the X Coordinate
          TempString := RightTrim(LeftTrim(Mid(DataLine, StartSearch, EndSearch - StartSearch + 1)));
          face[NumFace].p2 := strtoint(TempString) + 1;

          // Search 'C:'
          Cnt := InStr(1, DataLine, 'C:');
          StartSearch := Cnt + 2;            // 'C:' is 2 char
          // From here we search the next space
          Cnt := StartSearch + 1;
          while (cnt < Length(DataLine)) do
            begin
              If ((Mid(DataLine, Cnt, 1) = ' ')  or (Mid(DataLine, Cnt, 1) = chr(9))) Then
                begin
                  EndSearch := Cnt - 1; //'here we got the end for 3rd Point in face
                  cnt := Length(DataLine);
                end;
              inc(cnt);
            end;
          //'We can record the X Coordinate
          TempString := RightTrim(LeftTrim(Mid(DataLine, StartSearch, EndSearch - StartSearch + 1)));
          face[NumFace].p3 := strtoint(TempString) + 1;
        end;
    end;
  CloseFile(File_Text);
end;

end.

