unit variables;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  StdCtrls;

const degree = 3.14158 / 180;

  //3D point type
  Type coordonnee3D = record
      x : Single ;                 //'X coord from the point
      y : Single ;                 //'Y coord from the point
      z : Single ;                 //'Z coord from the point
  End;

  //Face type
  Type Fce = record
      p1 : LongInt;               //'1st point from the face
      p2 : LongInt;               //'2nd point from the face
      p3 : LongInt;               //'3rd point from the face
  End;

function InStr(Start: integer; Source: string; SourceToFind: string): integer;
function Mid(Source: string; Start: integer; Length: integer): string;
function Right(Source: string; Lengths: integer): string;
function RightTrim(const s:String):String;
function LeftTrim(const s:String):String;

var
  pts               : array of coordonnee3D;
  pts2              : array of coordonnee3D;
  face              : array of Fce;
  facevue           : array of Fce;
  zbuff1            : array of Single;
  fichier           : String;
  nbp               : LongInt;
  nbf               : LongInt;
  nbf2              : LongInt;
  rx                : single;
  ry                : single;
  rz                : single;
  tx                : single;
  ty                : single;
  tz                : single;
  tmpx              : single;
  tmpy              : single;
  tmpz              : single;
  posit             : LongInt;
  cx,cy             : integer;

  File_Text         : TextFile;                   // We read as Text file
  File_Bin          : file of LongInt;            // Binary file to save
  Directory         : String;                     // Program folder
  ObjectFile        : String;                     // The file name infos
  BinFileName       : String;                     // Name from the binary file
  File_Loaded       : byte;
  zoom              : single;

implementation

function InStr(Start: integer; Source: string; SourceToFind: string): integer;
  begin
    Result := pos(SourceToFind,copy(Source,Start,Length(Source) - (Start - 1)));
  end;

function Mid(Source: string; Start: integer; Length: integer): string;
  begin
    Result := copy(Source,Start,Length);
  end;

function Right(Source: string; Lengths: integer): string;
 begin
   Result := copy(source,Length(Source) - Lengths+1,Lengths+1);
 end;

function RightTrim(const s:String):String;
 var
 i:integer;
   begin
     i:=length(s);
     while (i>0) and (s[i]<=#32) do
       Dec(i);
       result:=Copy(s,1,i);
   end;

function LeftTrim(const s:String):String;
 var
   i, L:integer;
 begin
   L:=length(s);
   i:=1;
   while (i<=L) and (s[i]<=#32) do
     Inc(i);
     result:=Copy(s,i, MaxInt);
   end;



end.

