//--------------------------------------------------------------
// File     : main.c
// Datum    : 29.06.2015
// Version  : Alpha 09
// Autor    : UB
// EMail    : mc-4u(@)t-online.de
// Web      : www.mikrocontroller-4u.de
// CPU      : STM32F429
// IDE      : CooCox CoIDE 1.7.4
// GCC      : 4.7 2012q4
// Module   : CMSIS_BOOT, M4_CMSIS_CORE
// Funktion : Client vom SysMonitor
// Hinweis  : Diese zwei Files muessen auf 8MHz stehen
//              "cmsis_boot/stm32f4xx.h"
//              "cmsis_boot/system_stm32f4xx.c"
// In Configuration diese Define hinzufgen :
// "STM32F429_439xx" , "__ASSEMBLY__" , "USE_STDPERIPH_DRIVER"
//--------------------------------------------------------------

#include "main.h"
#include "stm32_ub_lcd_ili9341.h"
#include "stm32_ub_font.h"
#include "stm32_ub_usb_cdc.h"
#include "stm32_ub_led.h"
#include <stdio.h>
#include <stdarg.h>
#include <string.h>


void monitorClient(void);
uint16_t ch=0; // globale Variable fuer aktuellen Kanal

int main(void)
{
  USB_CDC_STATUS_t status=0;

  SystemInit(); // Quarz Einstellungen aktivieren

  // USB init
  UB_USB_CDC_Init();
  // LED init
  UB_Led_Init();


  UB_LCD_Init();
  UB_LCD_LayerInit_Fullscreen();
  // auf Hintergrund schalten
  UB_LCD_SetLayer_1();
  // Hintergrund komplett mit einer Farbe fllen
  UB_LCD_FillLayer(RGB_COL_WHITE);
  // auf Vordergrund schalten
  UB_LCD_SetLayer_2();
  // Vordergrund komplett mit einer Farbe fllen
  UB_LCD_FillLayer(RGB_COL_GREEN);

  UB_Font_DrawString(10,10,"SYS-Monitor Client A09",&Arial_10x15,RGB_COL_WHITE,RGB_COL_RED);

  while(1)
  {
    status=UB_USB_CDC_GetStatus();
    if(status==USB_CDC_CONNECTED) {
      UB_Font_DrawString(10,30,"USB connected    ",&Arial_10x15,RGB_COL_BLACK,RGB_COL_WHITE);
      monitorClient();
    }
    else {
      UB_Font_DrawString(10,30,"USB not connected",&Arial_10x15,RGB_COL_BLACK,RGB_COL_WHITE);
    }
  }
}


void monitorClient(void) {
  USB_CDC_RXSTATUS_t status;
  char rx_buf[50];
  char buf[50];
  uint16_t len,n;

  status=UB_USB_CDC_ReceiveString(rx_buf);
  if(status==RX_READY) {
    UB_Led_Toggle(LED_GREEN);
    if(strcmp(rx_buf,"PAGE=1")==0) {
      UB_LCD_FillLayer(RGB_COL_GREEN);
      UB_Font_DrawString(10,10,"SYS-Monitor Client A09",&Arial_10x15,RGB_COL_WHITE,RGB_COL_RED);
      UB_Font_DrawString(10,70,"Date/Time",&Arial_10x15,RGB_COL_WHITE,RGB_COL_BLUE);
      UB_Font_DrawString(10,90,"DATE ",&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN);
      UB_Font_DrawString(10,110,"TIME ",&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN);
    }
    else if(strcmp(rx_buf,"PAGE=2")==0) {
      UB_LCD_FillLayer(RGB_COL_GREEN);
      UB_Font_DrawString(10,10,"SYS-Monitor Client A09",&Arial_10x15,RGB_COL_WHITE,RGB_COL_RED);
      UB_Font_DrawString(10,70,"OHM-Sensors",&Arial_10x15,RGB_COL_WHITE,RGB_COL_BLUE);
      UB_Font_DrawString(10,90,"CPU-2 Load [%] ",&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN);
      UB_Font_DrawString(10,110,"GPU Load [%] ",&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN);
      UB_Font_DrawString(10,130,"Voltage ",&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN);
    }
    else if(strcmp(rx_buf,"PAGE=3")==0) {
      UB_LCD_FillLayer(RGB_COL_GREEN);
      UB_Font_DrawString(10,10,"SYS-Monitor Client A09",&Arial_10x15,RGB_COL_WHITE,RGB_COL_RED);
      UB_Font_DrawString(10,70,"WinAmp-Data",&Arial_10x15,RGB_COL_WHITE,RGB_COL_BLUE);
      UB_Font_DrawString(10,90,"Title ",&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN);
      UB_Font_DrawString(10,110,"Lenght ",&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN);
      UB_Font_DrawString(10,130,"Time ",&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN);
    }
    else if(strcmp(rx_buf,"GET_SYS_DATE")==0) ch=01;
    else if(strcmp(rx_buf,"GET_SYS_TIME")==0) ch=02;
    else if(strcmp(rx_buf,"GET_OHM_SENSOR:4")==0) ch=11;
    else if(strcmp(rx_buf,"GET_OHM_SENSOR:6")==0) ch=12;
    else if(strcmp(rx_buf,"GET_OHM_SENSOR:8")==0) ch=13;
    else if(strcmp(rx_buf,"GET_WINAMP_TITLE")==0) ch=21;
    else if(strcmp(rx_buf,"GET_WINAMP_LEN")==0) ch=22;
    else if(strcmp(rx_buf,"GET_WINAMP_TIME")==0) ch=23;
    else if(strncmp(rx_buf,"Value=",6)==0) {
      // Wert von Value trennen (max 10 Zeichen)
      len=strlen(rx_buf);
      if(len>16) len=16;
      for(n=0;n<(len-6);n++) {
        buf[n]=rx_buf[n+6];
      }
      buf[n]=0x00;
      if(ch==01) UB_Font_DrawString(100,90,buf,&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN);// Value von Sys-DATE
      else if(ch==02) UB_Font_DrawString(100,110,buf,&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN); // Value von Sys-TIME
      else if(ch==11) UB_Font_DrawString(170,90,buf,&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN); // Value von Sensor-4
      else if(ch==12) UB_Font_DrawString(170,110,buf,&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN); // Value von Sensor-6
      else if(ch==13) UB_Font_DrawString(170,130,buf,&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN); // Value von Sensor-8
      else if(ch==21) UB_Font_DrawString(100,90,buf,&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN); // Value von WinAmp-Title
      else if(ch==22) UB_Font_DrawString(100,110,buf,&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN); // Value von WinAmp-Len
      else if(ch==23) UB_Font_DrawString(100,130,buf,&Arial_10x15,RGB_COL_BLACK,RGB_COL_GREEN); // Value von WinAmp-Time
      ch=0;
    }
  }
}

