//--------------------------------------------------------------
// File     : main.c
// Datum    : 08.01.2015
// Version  : 1.0
// Autor    : UB
// EMail    : mc-4u(@)t-online.de
// Web      : www.mikrocontroller-4u.de
// CPU      : STM32F429
// IDE      : CooCox CoIDE 1.7.4
// GCC      : 4.7 2012q4
// Module   : CMSIS_BOOT, M4_CMSIS_CORE
// Funktion : Game-Of-Life
// Hinweis  : Diese zwei Files muessen auf 8MHz stehen
//              "cmsis_boot/stm32f4xx.h"
//              "cmsis_boot/system_stm32f4xx.c"
// In Configuration diese Define hinzufgen :
// "STM32F429_439xx" , "__ASSEMBLY__" , "USE_STDPERIPH_DRIVER"
//--------------------------------------------------------------

#include "main.h"
#include "stm32_ub_lcd_ili9341.h"
#include "stm32_ub_font.h"
#include "stm32_ub_gol.h"
#include "stm32_ub_button.h"
#include "stm32_ub_led.h"

//--------------------------------------------------------------
void pause(uint32_t delay)
{
	uint32_t n;

	for(n=0;n<delay;n++);
}

//--------------------------------------------------------------
int main(void)
{
  uint16_t n;

  SystemInit(); // Quarz Einstellungen aktivieren

  UB_LCD_Init();
  UB_LCD_LayerInit_Fullscreen();
  // auf Hintergrund schalten
  UB_LCD_SetLayer_1();
  // Hintergrund komplett mit einer Farbe fllen
  UB_LCD_FillLayer(RGB_COL_WHITE);
  // auf Vordergrund schalten
  UB_LCD_SetLayer_2();
  // Vordergrund komplett mit einer Farbe fllen
  UB_LCD_FillLayer(RGB_COL_WHITE);

  UB_Button_Init();
  UB_Led_Init();

  UB_Font_DrawString(10,10,"Conway's Game-Of-Life",&Arial_10x15,RGB_COL_WHITE,RGB_COL_RED);
  UB_Font_DrawString(10,50,"press User-Button",&Arial_10x15,RGB_COL_BLACK,RGB_COL_WHITE);
  UB_Font_DrawString(10,90,"PG13 = frame speed",&Arial_10x15,RGB_COL_BLACK,RGB_COL_WHITE);
  UB_Font_DrawString(10,120,"(120x160 = ca 100ms)",&Arial_10x15,RGB_COL_BLACK,RGB_COL_WHITE);

  while(UB_Button_Read(BTN_USER)==BTN_RELEASED)
  {
    n++;
  }
  srand(n);


  GOL_Init();
  GOL_SetCellsRandom();
  GOL_ShowAllCells();

  while(1)
  {
	  GOL_UpdateAllCells();
	  GOL_ShowAllCells();
	  UB_Led_Toggle(LED_GREEN);
	 // pause(5000);
  }
}

