//--------------------------------------------------------------
// File     : stm32_ub_gol.h
//--------------------------------------------------------------

//--------------------------------------------------------------
#ifndef __STM32F4_UB_GOL_H
#define __STM32F4_UB_GOL_H


//--------------------------------------------------------------
// Includes
//--------------------------------------------------------------
#include "stm32f4xx.h"
#include "stm32_ub_lcd_ili9341.h"
#include "stm32_ub_graphic2d.h"
#include <stdlib.h>


//--------------------------------------------------------------
// anzahl der Zellen
//--------------------------------------------------------------
#define  CELL_ANZ_X  120  // max 240
#define  CELL_ANZ_Y  160  // max 320


//--------------------------------------------------------------
// groesse der Zellen (wird berechnet)
//--------------------------------------------------------------
#define  CELL_SIZE_X    LCD_MAXX/CELL_ANZ_X
#define  CELL_SIZE_Y    LCD_MAXY/CELL_ANZ_Y

//--------------------------------------------------------------
// farbe der Zelle
//--------------------------------------------------------------
#define  CELL_COL_ALIVE   RGB_COL_BLACK
#define  CELL_COL_DEAD    RGB_COL_WHITE


//--------------------------------------------------------------
// status der Zelle
// bit0 = aktueller status, bit1=next status
// 0=dead, 1=alive
//--------------------------------------------------------------
uint8_t CELL[CELL_ANZ_X][CELL_ANZ_Y];



//--------------------------------------------------------------
// Globale Funktionen
//--------------------------------------------------------------
void GOL_Init(void);
void GOL_SetCellsRandom(void);
void GOL_ShowAllCells(void);
void GOL_UpdateAllCells(void);



//--------------------------------------------------------------
#endif // __STM32F4_UB_GOL_H
