//--------------------------------------------------------------
// File     : main.c
// Datum    : 19.12.2014
// Version  : 1.1
// Autor    : UB
// EMail    : mc-4u(@)t-online.de
// Web      : www.mikrocontroller-4u.de
// CPU      : STM32F429
// IDE      : CooCox CoIDE 1.7.4
// GCC      : 4.7 2012q4
// Module   : CMSIS_BOOT, M4_CMSIS_CORE
// Funktion : Mandelbrot-Demo (von Markus N.)
//            added with "rgb_map" (from UB)
// Hinweis  : Diese zwei Files muessen auf 8MHz stehen
//              "cmsis_boot/stm32f4xx.h"
//              "cmsis_boot/system_stm32f4xx.c"
// In Configuration diese Define hinzufgen :
// "STM32F429_439xx" , "__ASSEMBLY__" , "USE_STDPERIPH_DRIVER"
//
// to increase speed :
// turn on Hardware FPU and set code optimization to "-O3"
//--------------------------------------------------------------


#include "main.h"
#include "stm32_ub_lcd_ili9341.h"
#include "stm32_ub_font.h"
#include "stm32_ub_touch_stmpe811.h"
#include "stm32f4xx_dma2d.h"



#define  MAX_COLOR_ZONES   360 // (max 360)

uint16_t rgb_map[MAX_COLOR_ZONES];


//--------------------------------------------------------------
void fractal_mandelbrot(void);
void draw_mandelbrot (float x_start, float y_start, float zoom);
int isElement(float a, float b);
void set_color_map(void);
uint16_t akt_color_zones=0;

//--------------------------------------------------------------



//Mandelbrot Settings
float width = 3.0f;
float start_real = -2.0f;
float start_imag = -1.5f;
//--------------------------------------------------------------

int main(void)
{
  uint16_t xp,yp;
  akt_color_zones=0;

  SystemInit(); // Quarz Einstellungen aktivieren

  // Init vom LCD
  UB_LCD_Init();
  // auf Landscape schalten
  UB_LCD_SetMode(LANDSCAPE);
  // Init der Layer
  UB_LCD_LayerInit_Fullscreen();
  // auf Hintergrund schalten
  UB_LCD_SetLayer_1();
  // Hintergrund komplett mit einer Farbe fllen
  UB_LCD_FillLayer(RGB_COL_WHITE);
  // auf Vordergrund schalten
  UB_LCD_SetLayer_2();
  // Vordergrund komplett mit einer Farbe fllen
  UB_LCD_FillLayer(RGB_COL_WHITE);



  // init und Check vom Touch
  if(UB_Touch_Init()!=SUCCESS) {
    UB_Font_DrawString(200,10,"Touch Error",&Arial_11x18,RGB_COL_WHITE,RGB_COL_RED);
    UB_Font_DrawString(180,10,"repower the hardware",&Arial_11x18,RGB_COL_WHITE,RGB_COL_RED);
    while(1);
  }
  else {
	UB_Font_DrawString(220,10,"Fractal Demo",&Arial_11x18,RGB_COL_WHITE,RGB_COL_BLACK);
	UB_Font_DrawString(200,10,"by Markus N.",&Arial_11x18,RGB_COL_BLACK,RGB_COL_WHITE);
	UB_Font_DrawString(180,10,"tip touch to zoom in",&Arial_11x18,RGB_COL_BLACK,RGB_COL_WHITE);
	UB_Font_DrawString(140,10,"press here for 360 Colors",&Arial_11x18,RGB_COL_WHITE,RGB_COL_MAGENTA);
	UB_Font_DrawString(100,10,"press here for 180 Colors",&Arial_11x18,RGB_COL_WHITE,RGB_COL_MAGENTA);
	UB_Font_DrawString(60,10,"press here for 90 Colors",&Arial_11x18,RGB_COL_WHITE,RGB_COL_MAGENTA);
	UB_Font_DrawString(20,10,"press here for 45 Colors",&Arial_11x18,RGB_COL_WHITE,RGB_COL_MAGENTA);


	while(1)
	{
	    // Touch auslesen
	    UB_Touch_Read();
	    if(Touch_Data.status==TOUCH_PRESSED) {
	    	xp=Touch_Data.xp;
	    	yp=Touch_Data.yp;
	    	if((yp < 310) && (yp >= 10)) {
	    		if((xp < 165) && (xp >= 135 )) {
	    			akt_color_zones=360;
	    		}
	    		else if((xp < 125) && (xp >= 95 )) {
	    			akt_color_zones=180;
	    		}
	    		else if((xp < 85) && (xp >= 55 )) {
	    			akt_color_zones=90;
	    		}
	    		else if((xp < 45) && (xp >= 15 )) {
	    			akt_color_zones=45;
	    		}
	    	}
	    }
	    else if(akt_color_zones!=0 ){
	    	fractal_mandelbrot();
	    }
	}
  }
}

//--------------------------------------------------------------
void fractal_mandelbrot(void)
{
	uint16_t xp,yp;

 UB_LCD_FillLayer(RGB_COL_WHITE);
 set_color_map();

 draw_mandelbrot(start_real,start_imag,width);

 float pressed_real, pressed_imag;
  while(1)
  {
    // Touch auslesen
    UB_Touch_Read();
    if(Touch_Data.status==TOUCH_PRESSED) {
    	xp=Touch_Data.xp;
    	yp=Touch_Data.yp;
    	if((yp < 319) && (yp >= 1)) {
    		if((xp < 239) && (xp >= 1 )) {

    			pressed_real = (((width)*(float)yp)/320.0f)+start_real;
    			pressed_imag = (((width)*(float)xp)/240.0f)+start_imag;
    			width = width / 2.0f;
    			start_real = pressed_real - (width/2.0f);
    			start_imag = pressed_imag - (width/2.0f);


    			draw_mandelbrot (start_real, start_imag, width);


    		}
    	}
    }
  }
}


//--------------------------------------------------------------
int isElement(float a, float b) {
    float x = 0, x2, y = 0;

	    int counter = 0;
	    while (x*x+y*y < 2 && counter <= akt_color_zones) {
	    	 x2 = x * x - y * y + a;
		     y = 2 * x * y + b;
		     x = x2;
		     counter ++;
	    }
	    return counter;

}
 //--------------------------------------------------------------
void draw_mandelbrot (float real_start, float imag_start, float width) {
	  UB_LCD_SetCursor2Draw(0,0);
	  int w = 320, h = 240;

	  float a,b;

	  int i, j;
	  for (i = 0; i < h; i++) {
	  	 b = (float) i * width / h + imag_start;


	  	 for (j = 0; j < w; j++) {
	  	    a = (float) j * width / w + real_start; //-2 <= a < 1


	  	    int it = isElement(a, b);
	  	    if (it >= akt_color_zones) UB_LCD_DrawPixel(RGB_COL_BLACK);
	  	    else UB_LCD_DrawPixel(rgb_map[it]);


	  	  }
	 }
}




//--------------------------------------------------------------
// wandelt einen HSV-Farbwert in einen RGB-Farbwert um
// (Funktion von UlrichRadig.de)
//--------------------------------------------------------------
void RGB_2_HSV(COL_HSV_t hsv_col, COL_RGB_t *rgb_col)
{
  uint8_t diff;

  // Grenzwerte
  if(hsv_col.h>359) hsv_col.h=359;
  if(hsv_col.s>100) hsv_col.s=100;
  if(hsv_col.v>100) hsv_col.v=100;

  if(hsv_col.h < 61) {
    rgb_col->red = 255;
    rgb_col->green = (425 * hsv_col.h) / 100;
    rgb_col->blue = 0;
  }else if(hsv_col.h < 121){
    rgb_col->red = 255 - ((425 * (hsv_col.h-60))/100);
    rgb_col->green = 255;
    rgb_col->blue = 0;
  }else if(hsv_col.h < 181){
    rgb_col->red = 0;
    rgb_col->green = 255;
    rgb_col->blue = (425 * (hsv_col.h-120))/100;
  }else if(hsv_col.h < 241){
    rgb_col->red = 0;
    rgb_col->green = 255 - ((425 * (hsv_col.h-180))/100);
    rgb_col->blue = 255;
  }else if(hsv_col.h < 301){
    rgb_col->red = (425 * (hsv_col.h-240))/100;
    rgb_col->green = 0;
    rgb_col->blue = 255;
  }else {
    rgb_col->red = 255;
    rgb_col->green = 0;
    rgb_col->blue = 255 - ((425 * (hsv_col.h-300))/100);
  }

  hsv_col.s = 100 - hsv_col.s;
  diff = ((255 - rgb_col->red) * hsv_col.s)/100;
  rgb_col->red = rgb_col->red + diff;
  diff = ((255 - rgb_col->green) * hsv_col.s)/100;
  rgb_col->green = rgb_col->green + diff;
  diff = ((255 - rgb_col->blue) * hsv_col.s)/100;
  rgb_col->blue = rgb_col->blue + diff;

  rgb_col->red = (rgb_col->red * hsv_col.v)/100;
  rgb_col->green = (rgb_col->green * hsv_col.v)/100;
  rgb_col->blue = (rgb_col->blue * hsv_col.v)/100;
}




//--------------------------------------------------------------
void set_color_map(void)
{
	uint32_t n;
	uint8_t r=0x1F,g=0x3F,b=0x1F;
	uint8_t step;
	COL_HSV_t hsv_col;
	COL_RGB_t rgb_col;

	hsv_col.h=0;
	hsv_col.s=100;
	hsv_col.v=100;

	if(akt_color_zones>MAX_COLOR_ZONES) akt_color_zones=MAX_COLOR_ZONES;


	step=(360)/akt_color_zones;
	if(step<1) step=1;

	// set all colors
	for(n=0;n<akt_color_zones;n++) {
		RGB_2_HSV(hsv_col,&rgb_col);
		r=rgb_col.red>>3;
		g=rgb_col.green>>2;
		b=rgb_col.blue>>3;

	  rgb_map[n]=(r<<11)|(g<<5)|(b);
	  hsv_col.h+=step;
	  if(hsv_col.h>359) hsv_col.h=359;
	}
}
