#include "stm32f4xx_gpio.h"
#include "stm32f4xx_rcc.h"

void Delay(volatile uint32_t nCount)
{
	while(nCount--)
	{
	}
}

void init(void)
{
	GPIO_InitTypeDef GPIO_InitStructure;
	
	// Clock Enable
	RCC_AHB1PeriphClockCmd(RCC_AHB1Periph_GPIOD, ENABLE);
	
	// Config PD12 als Digital-Ausgang
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_OUT;
	GPIO_InitStructure.GPIO_OType = GPIO_OType_PP;
	GPIO_InitStructure.GPIO_PuPd = GPIO_PuPd_UP;
	GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
	GPIO_Init(GPIOD, &GPIO_InitStructure);
}

int main(void)
{
	init();
	while(1) {
		Delay(500000);
		GPIOD->ODR ^= GPIO_Pin_12; // PD12 toggeln
	}
}