//--------------------------------------------------------------
// File     : main.c
// Datum    : 27.11.2019
// Version  : 2.0
// Autor    : UB, MB
// EMail    : -
// Web      : mikrocontroller.bplaced.net
// CPU      : STM32F4
// IDE      : CooCox CoIDE 1.7.8
// GCC      : 9-2019-q4-major
// Module   : CMSIS_BOOT, M4_CMSIS_CORE
// Funktion : Demo der L298-Stepper-Library
// Hinweis  : Diese zwei Files muessen auf 8MHz stehen
//              "cmsis_boot/stm32f4xx.h"
//              "cmsis_boot/system_stm32f4xx.c"
//--------------------------------------------------------------

#include "main.h"
#include "stm32_ub_l298_stepper.h"
#include "stm32_ub_l298_2_stepper.h"

int main(void)
{
  SystemInit(); // Quarz Einstellungen aktivieren

  // init vom L298 im FullStep-Mode
  UB_L298_Init(L298_FULL_STEP);
  UB_L298_2_Init(L298_2_FULL_STEP);

  while(1)
  {
    // 1sec warten
    UB_L298_Pause_us(1000000);
    // Schrittmotor 30 Schritte nach rechts
    // mit 80% Speed
    UB_L298_StepRight(80,30);
    UB_L298_2_StepLeft(35,30);
    // 1sec warten
    UB_L298_Pause_us(1000000);
    // Schrittmotor 30 Schritte nach links
    // mit 35% Speed
    UB_L298_StepLeft(35,30);
    UB_L298_2_StepRight(80,30);
  }
}

